/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.damagesource.DamageSourcesPM;
import com.verdantartifice.primalmagick.common.damagesource.DamageTypesPM;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellBoltPacket;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.util.EntitySelectorsPM;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="primalmagick")
public class CombatEvents {
    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        Entity targetLevel;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player target = (Player)livingEntity;
            if (event.getSource().m_269533_(DamageTypeTags.f_268745_) && AttunementManager.meetsThreshold(target, Source.INFERNAL, AttunementThreshold.GREATER)) {
                event.setCanceled(true);
                return;
            }
            targetLevel = target.m_9236_();
            if (targetLevel.f_46441_.m_188500_() < 0.5 && !target.m_21023_(MobEffects.f_19609_) && AttunementManager.meetsThreshold(target, Source.MOON, AttunementThreshold.LESSER)) {
                targetLevel.m_5594_(target, target.m_20183_(), (SoundEvent)SoundsPM.SHIMMER.get(), SoundSource.PLAYERS, 1.0f, 1.0f + 0.05f * (float)targetLevel.f_46441_.m_188583_());
                target.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200));
            }
        }
        if ((targetLevel = event.getSource().m_7639_()) instanceof Player) {
            List<LivingEntity> targets;
            Player attacker = (Player)targetLevel;
            Level attackerLevel = attacker.m_9236_();
            if (!event.getSource().m_276093_(DamageTypesPM.HELLISH_CHAIN) && event.getAmount() > 0.0f && !attackerLevel.f_46443_ && AttunementManager.meetsThreshold(attacker, Source.INFERNAL, AttunementThreshold.LESSER) && !(targets = EntityUtils.getEntitiesInRangeSorted(attackerLevel, event.getEntity().m_20182_(), Arrays.asList(event.getEntity(), attacker), LivingEntity.class, 4.0, EntitySelectorsPM.validHellishChainTarget(attacker))).isEmpty()) {
                LivingEntity target = targets.get(0);
                target.m_6469_(DamageSourcesPM.hellishChain(attackerLevel, (LivingEntity)attacker), event.getAmount() / 2.0f);
                PacketHandler.sendToAllAround(new SpellBoltPacket(event.getEntity().m_20299_(1.0f), target.m_20299_(1.0f), Source.INFERNAL.getColor()), (ResourceKey<Level>)attackerLevel.m_46472_(), event.getEntity().m_20183_(), 64.0);
                attackerLevel.m_5594_(null, event.getEntity().m_20183_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f + (float)(attackerLevel.f_46441_.m_188583_() * 0.05));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player target = (Player)livingEntity;
            if (ResearchManager.isResearchComplete(target, SimpleResearchKey.FIRST_STEPS)) {
                SimpleResearchKey drownKey = ((ResearchName)ResearchNames.INTERNAL_DROWN_A_LITTLE.get()).simpleKey();
                if (event.getSource() == target.m_269291_().m_269063_() && !ResearchManager.isResearchComplete(target, drownKey)) {
                    ResearchManager.completeResearch(target, drownKey);
                }
                SimpleResearchKey lavaKey = ((ResearchName)ResearchNames.INTERNAL_FEEL_THE_BURN.get()).simpleKey();
                if (event.getSource() == target.m_269291_().m_269233_() && !ResearchManager.isResearchComplete(target, lavaKey)) {
                    ResearchManager.completeResearch(target, lavaKey);
                }
            }
            if (event.getSource() == target.m_269291_().m_268989_() && AttunementManager.meetsThreshold(target, Source.SKY, AttunementThreshold.LESSER)) {
                float newDamage = Math.max(0.0f, event.getAmount() / 3.0f - 2.0f);
                if (newDamage < event.getAmount()) {
                    event.setAmount(newDamage);
                }
                if (event.getAmount() < 1.0f) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                    return;
                }
            }
            if (!event.getSource().m_269533_(DamageTypeTags.f_268437_) && AttunementManager.meetsThreshold(target, Source.VOID, AttunementThreshold.LESSER)) {
                event.setAmount(0.9f * event.getAmount());
            }
            if (!event.getSource().m_269533_(DamageTypeTags.f_268437_) && event.getAmount() > 0.0f) {
                PrimalMagickCapabilities.getWard(target).ifPresent(wardCap -> {
                    if (event.getAmount() >= wardCap.getCurrentWard()) {
                        event.setAmount(event.getAmount() - wardCap.getCurrentWard());
                        wardCap.setCurrentWard(0.0f);
                    } else {
                        wardCap.decrementCurrentWard(event.getAmount());
                        event.setAmount(0.0f);
                    }
                    wardCap.pauseRegeneration();
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverTarget = (ServerPlayer)target;
                        wardCap.sync(serverTarget);
                    }
                });
            }
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Player attacker = (Player)event.getSource().m_7639_();
            Level level = attacker.m_9236_();
            if (!event.getSource().m_269533_(DamageTypeTags.f_268437_) && AttunementManager.meetsThreshold(attacker, Source.VOID, AttunementThreshold.GREATER)) {
                event.setAmount(1.25f * event.getAmount());
            }
            if (event.getEntity().m_21222_() && AttunementManager.meetsThreshold(attacker, Source.HALLOWED, AttunementThreshold.LESSER)) {
                event.setAmount(2.0f * event.getAmount());
            }
            if (event.getAmount() >= 1.0f && AttunementManager.meetsThreshold(attacker, Source.BLOOD, AttunementThreshold.LESSER)) {
                event.getEntity().m_7292_(new MobEffectInstance((MobEffect)EffectsPM.BLEEDING.get(), 200));
            }
            if (level.f_46441_.m_188501_() < event.getAmount() / 12.0f && AttunementManager.meetsThreshold(attacker, Source.BLOOD, AttunementThreshold.GREATER)) {
                attacker.m_5634_(1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Level level = player.m_9236_();
            IPlayerCooldowns cooldowns = PrimalMagickCapabilities.getCooldowns(player);
            if (AttunementManager.meetsThreshold(player, Source.HALLOWED, AttunementThreshold.GREATER) && cooldowns != null && !cooldowns.isOnCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE)) {
                player.m_21153_(1.0f);
                player.m_21219_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_7292_(new MobEffectInstance((MobEffect)EffectsPM.WEAKENED_SOUL.get(), 6000, 0, true, false, true));
                cooldowns.setCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE, 6000);
                level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundsPM.ANGELS.get(), SoundSource.PLAYERS, 1.0f, 1.0f + 0.05f * (float)level.f_46441_.m_188583_());
                event.setCanceled(true);
            }
        }
        if (entity.m_21023_((MobEffect)EffectsPM.DRAIN_SOUL.get()) && !event.isCanceled()) {
            float gems = entity.m_6095_().m_20674_().m_21609_() ? Mth.m_14116_((float)entity.m_21233_()) / 20.0f : entity.m_21233_() / 20.0f;
            int wholeGems = Mth.m_14143_((float)gems);
            int slivers = Mth.m_14143_((float)(Mth.m_14187_((float)gems) * 10.0f));
            Containers.m_18992_((Level)entity.m_20193_(), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (ItemStack)new ItemStack((ItemLike)ItemsPM.SOUL_GEM.get(), wholeGems));
            Containers.m_18992_((Level)entity.m_20193_(), (double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (ItemStack)new ItemStack((ItemLike)ItemsPM.SOUL_GEM_SLIVER.get(), slivers));
        }
    }

    @SubscribeEvent
    public static void onArrowImpact(ProjectileImpactEvent event) {
        Entity targetEntity;
        HitResult rayTraceResult;
        Entity shooter = event.getProjectile().m_19749_();
        if (shooter instanceof LivingEntity && EnchantmentHelperPM.hasEnderport((LivingEntity)shooter)) {
            EntityUtils.teleportEntity((LivingEntity)shooter, event.getProjectile().m_9236_(), event.getRayTraceResult().m_82450_());
        }
        if ((rayTraceResult = event.getRayTraceResult()).m_6662_() == HitResult.Type.ENTITY && (targetEntity = ((EntityHitResult)rayTraceResult).m_82443_()) instanceof LivingEntity) {
            MobEffectInstance soulpiercedInstance;
            LivingEntity livingShooter;
            int soulpiercingLevel;
            LivingEntity target = (LivingEntity)targetEntity;
            if (shooter instanceof LivingEntity && (soulpiercingLevel = (livingShooter = (LivingEntity)shooter).m_21205_().getEnchantmentLevel((Enchantment)EnchantmentsPM.SOULPIERCING.get())) > 0 && target.m_7301_(soulpiercedInstance = new MobEffectInstance((MobEffect)EffectsPM.SOULPIERCED.get(), 12000, 0, false, false)) && !target.m_21023_(soulpiercedInstance.m_19544_())) {
                Containers.m_18992_((Level)target.m_9236_(), (double)target.m_20185_(), (double)target.m_20186_(), (double)target.m_20189_(), (ItemStack)new ItemStack((ItemLike)ItemsPM.SOUL_GEM_SLIVER.get(), soulpiercingLevel));
                target.m_7292_(soulpiercedInstance);
            }
        }
    }

    @SubscribeEvent
    public static void onPotionApplicable(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_() == EffectsPM.BLEEDING.get() && event.getEntity().m_21222_()) {
            event.setResult(Event.Result.DENY);
        }
    }
}

