/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.armor.WardingModuleItem;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tags.DamageTypeTagsPM;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="primalmagick")
public class EntityEvents {
    @SubscribeEvent
    public static void onEnderEntityTeleport(EntityTeleportEvent.EnderEntity event) {
        if (event.isCancelable() && event.getEntityLiving().m_21023_((MobEffect)EffectsPM.ENDERLOCK.get())) {
            event.setCanceled(true);
        }
        EntityEvents.checkEnderward((EntityTeleportEvent)event, event.getEntityLiving());
    }

    @SubscribeEvent
    public static void onEnderPearlTeleport(EntityTeleportEvent.EnderPearl event) {
        if (event.isCancelable() && event.getPlayer().m_21023_((MobEffect)EffectsPM.ENDERLOCK.get())) {
            event.setCanceled(true);
        }
        EntityEvents.checkEnderward((EntityTeleportEvent)event, (LivingEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onChorusFruitTeleport(EntityTeleportEvent.ChorusFruit event) {
        if (event.isCancelable() && event.getEntityLiving().m_21023_((MobEffect)EffectsPM.ENDERLOCK.get())) {
            event.setCanceled(true);
        }
        EntityEvents.checkEnderward((EntityTeleportEvent)event, event.getEntityLiving());
    }

    private static void checkEnderward(EntityTeleportEvent event, LivingEntity entity) {
        if (event.isCancelable() && !event.isCanceled()) {
            double edgeLength = 32.0;
            AABB searchAABB = AABB.m_165882_((Vec3)event.getTarget(), (double)edgeLength, (double)edgeLength, (double)edgeLength);
            if (BlockPos.m_121921_((AABB)searchAABB).anyMatch(pos -> entity.m_9236_().m_8055_(pos).m_60713_((Block)BlocksPM.ENDERWARD.get()))) {
                event.setCanceled(true);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.enderward.block").m_130940_(ChatFormatting.RED), true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEnderPearlTeleportLowest(EntityTeleportEvent.EnderPearl event) {
        ServerPlayer entity = event.getPlayer();
        Vec3 start = entity.m_20182_();
        Vec3 end = new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        StatsManager.incrementValue((Player)entity, StatsPM.DISTANCE_TELEPORTED_CM, (int)(100.0 * start.m_82554_(end)));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onChorusFruitTeleportLowest(EntityTeleportEvent.ChorusFruit event) {
        LivingEntity entity = event.getEntityLiving();
        if (!event.isCanceled() && entity instanceof Player) {
            Vec3 start = entity.m_20182_();
            Vec3 end = new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            StatsManager.incrementValue((Player)entity, StatsPM.DISTANCE_TELEPORTED_CM, (int)(100.0 * start.m_82554_(end)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnimalTameLowest(AnimalTameEvent event) {
        SimpleResearchKey tameKey = ((ResearchName)ResearchNames.INTERNAL_FURRY_FRIEND.get()).simpleKey();
        Player player = event.getTamer();
        if (!event.isCanceled() && event.getAnimal() instanceof Wolf && ResearchManager.isResearchComplete(player, SimpleResearchKey.FIRST_STEPS) && !ResearchManager.isResearchComplete(player, tameKey)) {
            ResearchManager.completeResearch(player, tameKey);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBabyEntitySpawnLowest(BabyEntitySpawnEvent event) {
        SimpleResearchKey breedKey = ((ResearchName)ResearchNames.INTERNAL_BREED_ANIMAL.get()).simpleKey();
        Player player = event.getCausedByPlayer();
        if (!event.isCanceled() && player != null && ResearchManager.isResearchComplete(player, SimpleResearchKey.FIRST_STEPS) && !ResearchManager.isResearchComplete(player, breedKey)) {
            ResearchManager.completeResearch(player, breedKey);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = event.getItem();
        int currentDuration = event.getDuration();
        int maxDuration = stack.m_41779_();
        int delta = maxDuration - currentDuration;
        int enchantLevel = stack.getEnchantmentLevel((Enchantment)EnchantmentsPM.BULWARK.get());
        if (stack.m_41720_() instanceof ShieldItem && delta > 0 && delta % 5 == 0 && enchantLevel > 0) {
            MobEffectInstance effectInstance = entity.m_21124_(MobEffects.f_19606_);
            int amplifier = effectInstance == null ? 0 : Mth.m_14045_((int)(1 + effectInstance.m_19564_()), (int)0, (int)(enchantLevel - 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, amplifier));
        }
    }

    @SubscribeEvent
    public static void onLootingLevel(LootingLevelEvent event) {
        Entity caster;
        DamageSource source = event.getDamageSource();
        if (source != null && source.m_269533_(DamageTypeTagsPM.IS_MAGIC) && (caster = source.m_7639_()) != null && caster instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)caster;
            event.setLootingLevel(Math.max(event.getLootingLevel(), EnchantmentHelper.m_44836_((Enchantment)((Enchantment)EnchantmentsPM.TREASURE.get()), (LivingEntity)living)));
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (WardingModuleItem.hasWardAttached(event.getFrom()) || WardingModuleItem.hasWardAttached(event.getTo())) {
                PrimalMagickCapabilities.getWard((Player)serverPlayer).ifPresent(playerWard -> {
                    int newMax = playerWard.getApplicableSlots().stream().map(slot -> serverPlayer.m_6844_(slot)).filter(WardingModuleItem::hasWardAttached).mapToInt(stack -> 1 + WardingModuleItem.getAttachedWardLevel(stack)).sum();
                    playerWard.setMaxWard(newMax);
                    playerWard.sync(serverPlayer);
                });
            }
        }
    }
}

