/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.mojang.datafixers.util.Pair;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.misc.GlowFieldBlock;
import com.verdantartifice.primalmagick.common.blockstates.properties.TimePhase;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerAttunements;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerWard;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentHelperPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.items.misc.DreamVisionTalismanItem;
import com.verdantartifice.primalmagick.common.misc.EntitySwapper;
import com.verdantartifice.primalmagick.common.misc.InteractionRecord;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.ResetFallDistancePacket;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="primalmagick")
public class PlayerEvents {
    public static final Map<UUID, InteractionRecord> LAST_BLOCK_LEFT_CLICK = new HashMap<UUID, InteractionRecord>();
    private static final Map<UUID, Boolean> DOUBLE_JUMP_ALLOWED = new HashMap<UUID, Boolean>();
    private static final Set<UUID> NEAR_DEATH_ELIGIBLE = new HashSet<UUID>();
    private static final Supplier<SimpleResearchKey> NDE_RESEARCH_KEY = ResearchNames.simpleKey(ResearchNames.INTERNAL_NEAR_DEATH_EXPERIENCE);
    private static final UUID STEP_MODIFIER_EARTH_UUID = UUID.fromString("17b138bf-1d32-43a9-a690-59e0e4e0d0b6");
    private static final AttributeModifier STEP_MODIFIER_EARTH = new AttributeModifier(STEP_MODIFIER_EARTH_UUID, "Earth attunement step height bonus", 0.4, AttributeModifier.Operation.ADDITION);
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity;
        Level level = event.getEntity().m_9236_();
        if (!level.f_46443_ && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            PlayerEvents.checkNearDeathExperience(player);
            if (player.f_19797_ % 5 == 0) {
                PlayerEvents.applyAttunementBuffs(player);
                PlayerEvents.refreshWeakenedSoul(player);
            }
            if (player.f_19797_ % 10 == 0) {
                PlayerEvents.doScheduledSyncs(player, false);
            }
            if (player.f_19797_ % 20 == 0) {
                PlayerEvents.handleLightDrop(player);
                PlayerEvents.handleRegrowth((Player)player);
                PlayerEvents.handleWardRegeneration(player);
            }
            if (player.f_19797_ % 200 == 0) {
                PlayerEvents.checkEnvironmentalResearch(player);
                PlayerEvents.checkVanillaStatistics(player);
                PlayerEvents.handlePhotosynthesis(player);
            }
            if (player.f_19797_ % 1200 == 0) {
                AttunementManager.decayTemporaryAttunements((Player)player);
            }
        }
        if (level.f_46443_ && (livingEntity = event.getEntity()) instanceof Player) {
            player = (Player)livingEntity;
            PlayerEvents.handleDoubleJump((Player)player);
        }
    }

    protected static void checkNearDeathExperience(ServerPlayer player) {
        float health = player.m_21223_();
        UUID playerId = player.m_20148_();
        if (health > 0.0f && health <= 6.0f && !NEAR_DEATH_ELIGIBLE.contains(playerId)) {
            NEAR_DEATH_ELIGIBLE.add(playerId);
        }
        if (health <= 0.0f && NEAR_DEATH_ELIGIBLE.contains(playerId)) {
            NEAR_DEATH_ELIGIBLE.remove(playerId);
        }
        if (NEAR_DEATH_ELIGIBLE.contains(playerId) && health >= player.m_21233_() && ResearchManager.isResearchComplete((Player)player, SimpleResearchKey.FIRST_STEPS)) {
            if (!ResearchManager.isResearchComplete((Player)player, NDE_RESEARCH_KEY.get())) {
                ResearchManager.completeResearch((Player)player, NDE_RESEARCH_KEY.get());
            }
            NEAR_DEATH_ELIGIBLE.remove(playerId);
        }
    }

    protected static void applyAttunementBuffs(ServerPlayer player) {
        if (AttunementManager.meetsThreshold((Player)player, Source.SEA, AttunementThreshold.GREATER)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 610, 0, true, false, true));
        }
        if (AttunementManager.meetsThreshold((Player)player, Source.MOON, AttunementThreshold.GREATER)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 610, 0, true, false, true));
        }
        AttributeInstance stepHeightAttribute = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        stepHeightAttribute.m_22130_(STEP_MODIFIER_EARTH);
        if (!player.m_6144_() && AttunementManager.meetsThreshold((Player)player, Source.EARTH, AttunementThreshold.GREATER)) {
            stepHeightAttribute.m_22118_(STEP_MODIFIER_EARTH);
        }
    }

    protected static void refreshWeakenedSoul(ServerPlayer player) {
        long remaining;
        IPlayerCooldowns cooldowns = PrimalMagickCapabilities.getCooldowns((Player)player);
        if (cooldowns != null && (remaining = cooldowns.getRemainingCooldown(IPlayerCooldowns.CooldownType.DEATH_SAVE)) > 0L && !player.m_21023_((MobEffect)EffectsPM.WEAKENED_SOUL.get())) {
            player.m_7292_(new MobEffectInstance((MobEffect)EffectsPM.WEAKENED_SOUL.get(), Mth.m_14167_((float)((float)remaining / 50.0f)), 0, true, false, true));
        }
    }

    protected static void doScheduledSyncs(ServerPlayer player, boolean immediate) {
        IPlayerCompanions companions;
        IPlayerAttunements attunements;
        IPlayerStats stats;
        if (immediate || ResearchManager.isSyncScheduled((Player)player)) {
            PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> knowledge.sync(player));
        }
        if ((immediate || StatsManager.isSyncScheduled((Player)player)) && (stats = PrimalMagickCapabilities.getStats((Player)player)) != null) {
            stats.sync(player);
        }
        if ((immediate || AttunementManager.isSyncScheduled((Player)player)) && (attunements = PrimalMagickCapabilities.getAttunements((Player)player)) != null) {
            attunements.sync(player);
        }
        if ((immediate || CompanionManager.isSyncScheduled((Player)player)) && (companions = PrimalMagickCapabilities.getCompanions((Player)player)) != null) {
            companions.sync(player);
        }
        if (immediate || ArcaneRecipeBookManager.isSyncScheduled((Player)player)) {
            PrimalMagickCapabilities.getArcaneRecipeBook((Player)player).ifPresent(recipeBook -> recipeBook.sync(player));
        }
        if (immediate || LinguisticsManager.isSyncScheduled((Player)player)) {
            PrimalMagickCapabilities.getLinguistics((Player)player).ifPresent(linguistics -> linguistics.sync(player));
        }
        if (immediate) {
            IPlayerCooldowns cooldowns = PrimalMagickCapabilities.getCooldowns((Player)player);
            if (cooldowns != null) {
                cooldowns.sync(player);
            }
            PrimalMagickCapabilities.getWard((Player)player).ifPresent(wardCap -> wardCap.sync(player));
        }
    }

    protected static void checkEnvironmentalResearch(ServerPlayer player) {
        PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
            SimpleResearchKey key;
            Level level = player.m_9236_();
            if (!knowledge.isResearchKnown(SimpleResearchKey.FIRST_STEPS)) {
                return;
            }
            Holder biomeHolder = level.m_204166_(player.m_20183_());
            boolean inOverworld = level.m_46472_().equals((Object)Level.f_46428_);
            if (!knowledge.isResearchKnown(Source.INFERNAL.getDiscoverKey()) && biomeHolder.m_203656_(BiomeTags.f_207612_)) {
                ResearchManager.completeResearch((Player)player, Source.INFERNAL.getDiscoverKey());
                player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.discover_source.infernal").m_130940_(ChatFormatting.GREEN), false);
            }
            if (!knowledge.isResearchKnown(Source.VOID.getDiscoverKey()) && biomeHolder.m_203656_(BiomeTags.f_215818_)) {
                ResearchManager.completeResearch((Player)player, Source.VOID.getDiscoverKey());
                player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.discover_source.void").m_130940_(ChatFormatting.GREEN), false);
            }
            if (knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_EARTH.get()).simpleKey(1)) && !knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_EARTH.get()).simpleKey(2))) {
                key = ((ResearchName)ResearchNames.INTERNAL_ENV_EARTH.get()).simpleKey();
                if (player.m_20182_().f_82480_ < -16.0 && inOverworld && !knowledge.isResearchKnown(key)) {
                    ResearchManager.completeResearch((Player)player, key);
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.env_earth").m_130940_(ChatFormatting.GREEN), false);
                }
            }
            if (knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_SEA.get()).simpleKey(1)) && !knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_SEA.get()).simpleKey(2))) {
                key = ((ResearchName)ResearchNames.INTERNAL_ENV_SEA.get()).simpleKey();
                if (biomeHolder.m_203656_(BiomeTags.f_207603_) && !knowledge.isResearchKnown(key)) {
                    ResearchManager.completeResearch((Player)player, key);
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.env_sea").m_130940_(ChatFormatting.GREEN), false);
                }
            }
            if (knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_SKY.get()).simpleKey(1)) && !knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_SKY.get()).simpleKey(2))) {
                key = ((ResearchName)ResearchNames.INTERNAL_ENV_SKY.get()).simpleKey();
                if (player.m_20182_().f_82480_ > 128.0 && inOverworld && !knowledge.isResearchKnown(key)) {
                    ResearchManager.completeResearch((Player)player, key);
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.env_sky").m_130940_(ChatFormatting.GREEN), false);
                }
            }
            if (knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_SUN.get()).simpleKey(1)) && !knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_SUN.get()).simpleKey(2))) {
                key = ((ResearchName)ResearchNames.INTERNAL_ENV_SUN.get()).simpleKey();
                if ((biomeHolder.m_203565_(Biomes.f_48203_) || biomeHolder.m_203656_(BiomeTags.f_207607_)) && TimePhase.getSunPhase((LevelAccessor)level) == TimePhase.FULL && !knowledge.isResearchKnown(key)) {
                    ResearchManager.completeResearch((Player)player, key);
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.env_sun").m_130940_(ChatFormatting.GREEN), false);
                }
            }
            if (knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_MOON.get()).simpleKey(1)) && !knowledge.isResearchKnown(((ResearchName)ResearchNames.SOURCE_MOON.get()).simpleKey(2))) {
                key = ((ResearchName)ResearchNames.INTERNAL_ENV_MOON.get()).simpleKey();
                if (biomeHolder.m_203656_(BiomeTags.f_207611_) && TimePhase.getMoonPhase((LevelAccessor)level) == TimePhase.FULL && !knowledge.isResearchKnown(key)) {
                    ResearchManager.completeResearch((Player)player, key);
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.env_moon").m_130940_(ChatFormatting.GREEN), false);
                }
            }
        });
    }

    protected static void checkVanillaStatistics(ServerPlayer player) {
        SimpleResearchKey stoneKey;
        SimpleResearchKey torchKey;
        SimpleResearchKey elytraKey = ((ResearchName)ResearchNames.INTERNAL_FLY_ELYTRA.get()).simpleKey();
        if (!ResearchManager.isResearchComplete((Player)player, elytraKey) && player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12923_)) >= 100000) {
            ResearchManager.completeResearch((Player)player, elytraKey);
        }
        if (!ResearchManager.isResearchComplete((Player)player, torchKey = ((ResearchName)ResearchNames.INTERNAL_PLACE_TORCH_EXPERT.get()).simpleKey()) && player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)Items.f_42000_)) >= 100) {
            ResearchManager.completeResearch((Player)player, torchKey);
        }
        if (!ResearchManager.isResearchComplete((Player)player, stoneKey = ((ResearchName)ResearchNames.INTERNAL_PLACE_STONE_EXPERT.get()).simpleKey()) && player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)Items.f_41905_)) + player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)Items.f_42594_)) >= 100) {
            ResearchManager.completeResearch((Player)player, stoneKey);
        }
    }

    protected static void handlePhotosynthesis(ServerPlayer player) {
        Level level = player.m_9236_();
        if (AttunementManager.meetsThreshold((Player)player, Source.SUN, AttunementThreshold.LESSER) && level.m_46461_() && player.m_213856_() > 0.5f && level.m_45527_(player.m_20183_())) {
            player.m_36324_().m_38707_(1, 0.3f);
        }
    }

    protected static void handleLightDrop(ServerPlayer player) {
        BlockPos pos = player.m_20183_();
        Level world = player.m_9236_();
        if (world.f_46441_.m_188500_() < 0.1 && AttunementManager.meetsThreshold((Player)player, Source.SUN, AttunementThreshold.GREATER) && !player.m_6144_() && world.m_46859_(pos) && world.m_8055_(pos) != ((GlowFieldBlock)((Object)BlocksPM.GLOW_FIELD.get())).m_49966_() && world.m_45517_(LightLayer.BLOCK, pos) < 11) {
            world.m_7731_(pos, (BlockState)((GlowFieldBlock)((Object)BlocksPM.GLOW_FIELD.get())).m_49966_().m_61124_((Property)GlowFieldBlock.SPARKLING, (Comparable)Boolean.TRUE), 3);
        }
    }

    protected static void handleDoubleJump(Player player) {
        Minecraft mc = Minecraft.m_91087_();
        Level level = player.m_9236_();
        boolean jumpPressed = mc.f_91066_.f_92089_.m_90859_();
        if (jumpPressed && !DOUBLE_JUMP_ALLOWED.containsKey(player.m_20148_())) {
            DOUBLE_JUMP_ALLOWED.put(player.m_20148_(), Boolean.TRUE);
        }
        if (jumpPressed && !player.m_20096_() && !player.m_20069_() && DOUBLE_JUMP_ALLOWED.getOrDefault(player.m_20148_(), Boolean.FALSE).booleanValue() && AttunementManager.meetsThreshold(player, Source.SKY, AttunementThreshold.GREATER)) {
            level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.1f, 1.0f + 0.05f * (float)level.f_46441_.m_188583_(), false);
            DOUBLE_JUMP_ALLOWED.put(player.m_20148_(), Boolean.FALSE);
            Vec3 oldMotion = player.m_20184_();
            double motionX = oldMotion.f_82479_;
            double motionY = 0.75;
            double motionZ = oldMotion.f_82481_;
            if (player.m_21023_(MobEffects.f_19603_)) {
                motionY += 0.1 * (double)(1 + player.m_21124_(MobEffects.f_19603_).m_19564_());
            }
            if (player.m_20142_()) {
                float yawRadians = player.m_146908_() * ((float)Math.PI / 180);
                motionX -= 0.2 * (double)Mth.m_14031_((float)yawRadians);
                motionZ += 0.2 * (double)Mth.m_14089_((float)yawRadians);
            }
            player.m_20334_(motionX, motionY, motionZ);
            player.f_19789_ = 0.0f;
            PacketHandler.sendToServer(new ResetFallDistancePacket());
            ForgeHooks.onLivingJump((LivingEntity)player);
        }
        if (player.m_20096_() && DOUBLE_JUMP_ALLOWED.containsKey(player.m_20148_())) {
            DOUBLE_JUMP_ALLOWED.remove(player.m_20148_());
        }
    }

    protected static void handleRegrowth(Player player) {
        for (ItemStack stack : player.m_20158_()) {
            if (!stack.m_41768_() || !EnchantmentHelperPM.hasRegrowth(stack)) continue;
            stack.m_41622_(-1, (LivingEntity)player, p -> {});
        }
    }

    protected static void handleWardRegeneration(ServerPlayer player) {
        PrimalMagickCapabilities.getWard((Player)player).ifPresent(wardCap -> {
            if (wardCap.isRegenerating()) {
                for (EquipmentSlot slot : wardCap.getApplicableSlots()) {
                    IManaStorage manaCap;
                    LazyOptional manaCapOpt;
                    ItemStack slotStack = player.m_6844_(slot);
                    if (slotStack.m_41619_() || !(manaCapOpt = slotStack.getCapability(PrimalMagickCapabilities.MANA_STORAGE)).isPresent() || (manaCap = (IManaStorage)manaCapOpt.orElseThrow(IllegalArgumentException::new)).getManaStored(Source.EARTH) < 500) continue;
                    manaCap.extractMana(Source.EARTH, 500, false);
                    wardCap.incrementCurrentWard();
                    wardCap.sync(player);
                    player.f_8906_.m_9829_((Packet)new ClientboundSetEquipmentPacket(player.m_19879_(), List.of(Pair.of((Object)slot, (Object)slotStack.m_41777_()))));
                    break;
                }
            }
        });
    }

    @SubscribeEvent
    public static void playerJoinEvent(EntityJoinLevelEvent event) {
        Entity entity;
        Level world = event.getLevel();
        if (!world.f_46443_ && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerEvents.doScheduledSyncs(player, true);
            ArcaneRecipeBookManager.syncRecipesWithResearch(player);
        }
    }

    @SubscribeEvent
    public static void playerCloneEvent(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        try {
            CompoundTag nbtKnowledge = (CompoundTag)((IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(event.getOriginal()).orElseThrow(IllegalArgumentException::new)).serializeNBT();
            ((IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(event.getEntity()).orElseThrow(IllegalArgumentException::new)).deserializeNBT((Tag)nbtKnowledge);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} knowledge", (Object)event.getOriginal().m_7755_().getString());
        }
        try {
            CompoundTag nbtCooldowns = (CompoundTag)PrimalMagickCapabilities.getCooldowns(event.getOriginal()).serializeNBT();
            PrimalMagickCapabilities.getCooldowns(event.getEntity()).deserializeNBT((Tag)nbtCooldowns);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} cooldowns", (Object)event.getOriginal().m_7755_().getString());
        }
        try {
            CompoundTag nbtStats = (CompoundTag)PrimalMagickCapabilities.getStats(event.getOriginal()).serializeNBT();
            PrimalMagickCapabilities.getStats(event.getEntity()).deserializeNBT((Tag)nbtStats);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} stats", (Object)event.getOriginal().m_7755_().getString());
        }
        try {
            CompoundTag nbtAttunements = (CompoundTag)PrimalMagickCapabilities.getAttunements(event.getOriginal()).serializeNBT();
            PrimalMagickCapabilities.getAttunements(event.getEntity()).deserializeNBT((Tag)nbtAttunements);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} attunements", (Object)event.getOriginal().m_7755_().getString());
        }
        try {
            CompoundTag nbtCompanions = (CompoundTag)PrimalMagickCapabilities.getCompanions(event.getOriginal()).serializeNBT();
            PrimalMagickCapabilities.getCompanions(event.getEntity()).deserializeNBT((Tag)nbtCompanions);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} companions", (Object)event.getOriginal().m_7755_().getString());
        }
        try {
            CompoundTag nbtRecipeBook = ((IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook(event.getOriginal()).orElseThrow(IllegalArgumentException::new)).serializeNBT();
            ((IPlayerArcaneRecipeBook)PrimalMagickCapabilities.getArcaneRecipeBook(event.getEntity()).orElseThrow(IllegalArgumentException::new)).deserializeNBT(nbtRecipeBook, event.getEntity().m_9236_().m_7465_());
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} arcane recipe book", (Object)event.getOriginal().m_7755_().getString());
        }
        try {
            CompoundTag nbtWard = (CompoundTag)((IPlayerWard)PrimalMagickCapabilities.getWard(event.getOriginal()).orElseThrow(IllegalArgumentException::new)).serializeNBT();
            ((IPlayerWard)PrimalMagickCapabilities.getWard(event.getEntity()).orElseThrow(IllegalArgumentException::new)).deserializeNBT((Tag)nbtWard);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} ward", (Object)event.getOriginal().m_7755_().getString());
        }
        try {
            CompoundTag nbtLinguistics = (CompoundTag)((IPlayerLinguistics)PrimalMagickCapabilities.getLinguistics(event.getOriginal()).orElseThrow(IllegalArgumentException::new)).serializeNBT();
            ((IPlayerLinguistics)PrimalMagickCapabilities.getLinguistics(event.getEntity()).orElseThrow(IllegalArgumentException::new)).deserializeNBT((Tag)nbtLinguistics);
        }
        catch (Exception e) {
            LOGGER.error("Failed to clone player {} linguistics", (Object)event.getOriginal().m_7755_().getString());
        }
        event.getOriginal().invalidateCaps();
        if (event.isWasDeath()) {
            AttunementManager.refreshAttributeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        PlayerEvents.registerItemCrafted(event.getEntity(), event.getCrafting().m_41777_());
    }

    @SubscribeEvent
    public static void onSmelting(PlayerEvent.ItemSmeltedEvent event) {
        PlayerEvents.registerItemCrafted(event.getEntity(), event.getSmelting().m_41777_());
    }

    protected static void registerItemCrafted(Player player, ItemStack stack) {
        if (player != null && !player.m_9236_().f_46443_) {
            int stackHash = ItemUtils.getHashCode(stack);
            if (ResearchManager.getAllCraftingReferences().contains(stackHash)) {
                ResearchManager.completeResearch(player, SimpleResearchKey.parseCrafted(stackHash));
            }
            stack.m_204131_().filter(tag -> tag != null).forEach(tagKey -> {
                int tagHash = ("tag:" + tagKey.f_203868_().toString()).hashCode();
                if (ResearchManager.getAllCraftingReferences().contains(tagHash)) {
                    ResearchManager.completeResearch(player, SimpleResearchKey.parseCrafted(tagHash));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (player != null && !player.m_9236_().f_46443_) {
            NonNullList<ItemStack> foundTalismans;
            if (ResearchManager.isResearchComplete(player, ((ResearchName)ResearchNames.INTERNAL_FOUND_SHRINE.get()).simpleKey()) && !ResearchManager.isResearchComplete(player, ((ResearchName)ResearchNames.INTERNAL_GOT_DREAM.get()).simpleKey())) {
                PlayerEvents.grantDreamJournal(player);
            }
            if (!(foundTalismans = InventoryUtils.find(player, ((DreamVisionTalismanItem)((Object)ItemsPM.DREAM_VISION_TALISMAN.get())).m_7968_())).isEmpty()) {
                boolean success = false;
                for (ItemStack talismanStack : foundTalismans) {
                    DreamVisionTalismanItem talisman;
                    Item item = talismanStack.m_41720_();
                    if (!(item instanceof DreamVisionTalismanItem) || !(talisman = (DreamVisionTalismanItem)item).isActive(talismanStack) || !talisman.isReadyToDrain(talismanStack)) continue;
                    success = success || talisman.doDrain(talismanStack, player);
                }
                if (success) {
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.dream_vision_talisman.drained").m_130940_(ChatFormatting.GREEN), false);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        PacketHandler.sendToPlayer(new PlayClientSoundPacket((SoundEvent)SoundsPM.WRITING.get(), 1.0f, 1.0f + (float)player.m_217043_().m_188583_() * 0.05f), serverPlayer);
                    }
                }
            }
        }
    }

    protected static void grantDreamJournal(Player player) {
        ResearchManager.completeResearch(player, ((ResearchName)ResearchNames.INTERNAL_GOT_DREAM.get()).simpleKey());
        ItemStack journal = new ItemStack((ItemLike)ItemsPM.STATIC_BOOK.get());
        StaticBookItem.setBookDefinition(journal, (BookDefinition)BooksPM.DREAM_JOURNAL.get());
        StaticBookItem.setAuthorOverride(journal, player.m_7755_().getString());
        if (!player.m_36356_(journal)) {
            player.m_36176_(journal, false);
        }
        player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.got_dream").m_130940_(ChatFormatting.GREEN));
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && AttunementManager.meetsThreshold(player = (Player)event.getEntity(), Source.SKY, AttunementThreshold.GREATER)) {
            Vec3 motion = player.m_20184_();
            motion = motion.m_82520_(0.0, 0.275, 0.0);
            player.m_20256_(motion);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteractLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        LAST_BLOCK_LEFT_CLICK.put(event.getEntity().m_20148_(), new InteractionRecord(event.getEntity(), event.getHand(), event.getPos(), event.getFace()));
    }

    @SubscribeEvent
    public static void onPickupExperience(PlayerXpEvent.PickupXp event) {
        NonNullList<ItemStack> foundTalismans;
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (player != null && !level.f_46443_ && !(foundTalismans = InventoryUtils.find(player, ((DreamVisionTalismanItem)((Object)ItemsPM.DREAM_VISION_TALISMAN.get())).m_7968_())).isEmpty()) {
            int xpValue = event.getOrb().f_20770_;
            for (ItemStack foundStack : foundTalismans) {
                DreamVisionTalismanItem talisman;
                Item item = foundStack.m_41720_();
                if (!(item instanceof DreamVisionTalismanItem) || !(talisman = (DreamVisionTalismanItem)item).isActive(foundStack) || (xpValue = talisman.addStoredExp(foundStack, xpValue)) > 0) continue;
                event.getOrb().f_20770_ = 0;
                return;
            }
            event.getOrb().f_20770_ = xpValue;
        }
    }

    @SubscribeEvent
    public static void onUseHoe(BlockEvent.BlockToolModificationEvent event) {
        UseOnContext context = event.getContext();
        ItemStack stack = context.m_43722_();
        int enchantLevel = stack.getEnchantmentLevel((Enchantment)EnchantmentsPM.VERDANT.get());
        if (!event.isSimulated() && event.getToolAction().equals(ToolActions.HOE_TILL) && enchantLevel > 0) {
            BonemealableBlock mealBlock;
            Block block;
            Player player = event.getPlayer();
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = level.m_8055_(pos);
            if (!player.m_6144_() && (block = state.m_60734_()) instanceof BonemealableBlock && (mealBlock = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, state, level.f_46443_)) {
                if (level instanceof ServerLevel) {
                    int damage;
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (mealBlock.m_214167_(level, level.f_46441_, pos, state)) {
                        mealBlock.m_214148_(serverLevel, level.f_46441_, pos, state);
                    }
                    if ((damage = 8 >> enchantLevel - 1) > 0) {
                        stack.m_41622_(damage, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                    }
                    event.setFinalState(level.m_8055_(pos));
                }
                if (!level.f_46443_) {
                    level.m_46796_(1505, pos, 0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getEntity().m_21120_(event.getHand());
        Entity target = event.getTarget();
        Level level = target.m_9236_();
        if (!level.f_46443_ && target.m_6095_() == EntityType.f_20495_ && stack.m_41720_() instanceof NameTagItem && stack.m_41788_() && stack.m_41786_().getString().equals("Corspilla")) {
            CompoundTag originalData = target.m_20240_(new CompoundTag());
            EntitySwapper.enqueue(level, new EntitySwapper(target.m_20148_(), (EntityType)EntityTypesPM.FRIENDLY_WITCH.get(), originalData, Optional.empty(), 0));
            List<Player> nearby = EntityUtils.getEntitiesInRange(level, target.m_20182_(), null, Player.class, 32.0);
            for (Player player : nearby) {
                player.m_213846_((Component)Component.m_237110_((String)"event.primalmagick.friendly_witch.spawn", (Object[])new Object[]{"Corspilla"}));
            }
        }
    }
}

