/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.events;

import com.verdantartifice.primalmagick.common.misc.BlockBreaker;
import com.verdantartifice.primalmagick.common.misc.BlockSwapper;
import com.verdantartifice.primalmagick.common.misc.EntitySwapper;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="primalmagick")
public class ServerEvents {
    @SubscribeEvent
    public static void serverWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            ServerEvents.tickBlockSwappers(event.level);
            ServerEvents.tickBlockBreakers(event.level);
            ServerEvents.tickEntitySwappers(event.level);
        }
    }

    protected static void tickBlockSwappers(Level world) {
        Queue<BlockSwapper> swapperQueue = BlockSwapper.getWorldSwappers(world);
        if (swapperQueue != null) {
            while (!swapperQueue.isEmpty()) {
                BlockSwapper swapper = swapperQueue.poll();
                if (swapper == null) continue;
                swapper.execute(world);
            }
        }
    }

    protected static void tickBlockBreakers(Level world) {
        Iterable<BlockBreaker> breakers = BlockBreaker.tick(world);
        for (BlockBreaker breaker : breakers) {
            BlockBreaker newBreaker = breaker.execute(world);
            if (newBreaker == null) continue;
            BlockBreaker.schedule(world, 1, newBreaker);
        }
    }

    protected static void tickEntitySwappers(Level world) {
        Queue<EntitySwapper> swapperQueue = EntitySwapper.getWorldSwappers(world);
        if (swapperQueue != null) {
            LinkedBlockingQueue<EntitySwapper> newQueue = new LinkedBlockingQueue<EntitySwapper>();
            while (!swapperQueue.isEmpty()) {
                EntitySwapper swapper = swapperQueue.poll();
                if (swapper == null) continue;
                if (swapper.isReady()) {
                    EntitySwapper newSwapper = swapper.execute(world);
                    if (newSwapper == null) continue;
                    newQueue.offer(newSwapper);
                    continue;
                }
                swapper.decrementDelay();
                newQueue.offer(swapper);
            }
            EntitySwapper.setWorldSwapperQueue(world, newQueue);
        }
    }
}

