/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.armor;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum ArmorMaterialPM implements ArmorMaterial
{
    IMBUED_WOOL("imbued_wool", 8, new int[]{1, 3, 4, 1}, 17, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTags.f_13167_)),
    SPELLCLOTH("spellcloth", 20, new int[]{2, 5, 7, 2}, 22, SoundEvents.f_11678_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsPM.SPELLCLOTH.get()})),
    HEXWEAVE("hexweave", 35, new int[]{3, 7, 9, 3}, 27, SoundEvents.f_11678_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsPM.HEXWEAVE.get()})),
    SAINTSWOOL("saintswool", 50, new int[]{4, 8, 10, 4}, 32, SoundEvents.f_11678_, 3.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemsPM.SAINTSWOOL.get()})),
    PRIMALITE("primalite", 30, new int[]{3, 5, 7, 3}, 18, SoundEvents.f_11677_, 1.0f, 0.0f, () -> Ingredient.m_204132_(ItemTagsPM.INGOTS_PRIMALITE)),
    HEXIUM("hexium", 45, new int[]{4, 7, 9, 4}, 23, SoundEvents.f_11677_, 2.0f, 0.1f, () -> Ingredient.m_204132_(ItemTagsPM.INGOTS_HEXIUM)),
    HALLOWSTEEL("hallowsteel", 60, new int[]{5, 8, 10, 5}, 28, SoundEvents.f_11677_, 3.0f, 0.2f, () -> Ingredient.m_204132_(ItemTagsPM.INGOTS_HALLOWSTEEL));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairMaterial;

    private ArmorMaterialPM(String name, int maxDamageFactor, int[] damageReductionAmounts, int enchantability, SoundEvent equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterialSupplier) {
        this.name = "primalmagick:" + name;
        this.maxDamageFactor = maxDamageFactor;
        this.damageReductionAmountArray = damageReductionAmounts;
        this.enchantability = enchantability;
        this.soundEvent = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = new LazyLoadedValue(repairMaterialSupplier);
    }

    public int m_266425_(ArmorItem.Type type) {
        return MAX_DAMAGE_ARRAY[type.m_266308_().m_20749_()] * this.maxDamageFactor;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.damageReductionAmountArray[type.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

