/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.armor;

import com.verdantartifice.primalmagick.common.armortrim.TrimPatternsPM;
import com.verdantartifice.primalmagick.common.items.armor.IManaDiscountGear;
import com.verdantartifice.primalmagick.common.items.misc.RuneItem;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.SourceRune;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class RobeArmorItem
extends ArmorItem
implements IManaDiscountGear {
    protected final int manaDiscount;

    public RobeArmorItem(ArmorMaterial material, ArmorItem.Type type, int manaDiscount, Item.Properties properties) {
        super(material, type, properties);
        this.manaDiscount = manaDiscount;
    }

    @Override
    public int getManaDiscount(ItemStack stack, Player player, Source source) {
        Optional<Source> sourceOpt = this.getAttunedSource(stack, player);
        if (sourceOpt.isPresent()) {
            if (sourceOpt.get().equals(source)) {
                return 2 * this.manaDiscount;
            }
            return 0;
        }
        return this.manaDiscount;
    }

    @Override
    public int getBestManaDiscount(ItemStack stack, Player player) {
        Optional trimOpt;
        Optional optional = trimOpt = player == null ? Optional.empty() : ArmorTrim.m_266285_((RegistryAccess)player.m_9236_().m_9598_(), (ItemStack)stack);
        if (trimOpt.isPresent() && ((ArmorTrim)trimOpt.get()).m_266429_().m_203565_(TrimPatternsPM.RUNIC)) {
            return 2 * this.manaDiscount;
        }
        return this.manaDiscount;
    }

    @Override
    public Optional<Source> getAttunedSource(ItemStack stack, Player player) {
        RuneItem runeItem;
        Rune rune;
        Item trimItem;
        Optional trimOpt;
        Optional optional = trimOpt = player == null ? Optional.empty() : ArmorTrim.m_266285_((RegistryAccess)player.m_9236_().m_9598_(), (ItemStack)stack);
        if (trimOpt.isPresent() && ((ArmorTrim)trimOpt.get()).m_266429_().m_203565_(TrimPatternsPM.RUNIC) && (trimItem = (Item)((TrimMaterial)((ArmorTrim)trimOpt.get()).m_266210_().m_203334_()).f_265970_().m_203334_()) instanceof RuneItem && (rune = (runeItem = (RuneItem)trimItem).getRune()) instanceof SourceRune) {
            SourceRune sourceRune = (SourceRune)rune;
            return Optional.ofNullable(sourceRune.getSource());
        }
        return Optional.empty();
    }
}

