/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.armor;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WardingModuleItem
extends Item
implements ITieredDevice {
    public static final String TAG_NAME = String.join((CharSequence)":", "primalmagick", "WardingModule");
    public static final int MANA_CAPACITY = 10000;
    public static final int CHARGE_RATE = 10000;
    public static final int REGEN_COST = 500;
    protected static final List<Supplier<? extends Item>> APPLICABLE_ITEMS = ImmutableList.builder().add((Object[])new Supplier[]{ItemsPM.PRIMALITE_HEAD, ItemsPM.PRIMALITE_CHEST, ItemsPM.PRIMALITE_LEGS, ItemsPM.PRIMALITE_FEET, ItemsPM.HEXIUM_HEAD, ItemsPM.HEXIUM_CHEST, ItemsPM.HEXIUM_LEGS, ItemsPM.HEXIUM_FEET, ItemsPM.HALLOWSTEEL_HEAD, ItemsPM.HALLOWSTEEL_CHEST, ItemsPM.HALLOWSTEEL_LEGS, ItemsPM.HALLOWSTEEL_FEET}).build();
    protected final DeviceTier tier;

    public WardingModuleItem(DeviceTier tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    @Override
    public DeviceTier getDeviceTier() {
        return this.tier;
    }

    public boolean hasWard() {
        return this.getWardLevel() > 0;
    }

    public int getWardLevel() {
        return switch (this.getDeviceTier()) {
            case DeviceTier.ENCHANTED -> 1;
            case DeviceTier.FORBIDDEN -> 2;
            case DeviceTier.HEAVENLY -> 3;
            default -> 0;
        };
    }

    public static boolean hasWardAttached(ItemStack stack) {
        return stack.m_204117_(ItemTagsPM.WARDABLE_ARMOR) && stack.m_41782_() && stack.m_41783_().m_128441_(TAG_NAME) && WardingModuleItem.getAttachedWardLevel(stack) > 0;
    }

    public static int getAttachedWardLevel(ItemStack stack) {
        return stack.m_41783_().m_128451_(TAG_NAME);
    }

    public static List<Supplier<? extends Item>> getApplicableItems() {
        return APPLICABLE_ITEMS;
    }
}

