/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.books;

import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.CodexType;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PlayClientSoundPacket;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class LinguisticsGainItem
extends Item {
    public static final String TAG_BOOK_LANGUAGE_ID = "BookLanguageId";
    protected static final Map<CodexType, LinguisticsGainItem> TYPE_MAP = new HashMap<CodexType, LinguisticsGainItem>();
    protected final int amount;

    public LinguisticsGainItem(CodexType type, Item.Properties properties) {
        super(properties);
        this.amount = type.getAmount();
        TYPE_MAP.put(type, this);
    }

    public static ItemStack make(CodexType type, Optional<BookLanguage> bookLangOpt) {
        ItemStack retVal = new ItemStack((ItemLike)TYPE_MAP.get((Object)type));
        bookLangOpt.ifPresent(bookLang -> LinguisticsGainItem.setBookLanguage(retVal, bookLang));
        return retVal;
    }

    protected static Optional<ResourceLocation> getBookLanguageId(ItemStack stack) {
        String str;
        CompoundTag rootTag = stack.m_41783_();
        if (rootTag != null && !StringUtil.m_14408_((String)(str = rootTag.m_128461_(TAG_BOOK_LANGUAGE_ID)))) {
            return Optional.ofNullable(ResourceLocation.m_135820_((String)str));
        }
        return Optional.empty();
    }

    public static BookLanguage getBookLanguage(ItemStack stack) {
        return LinguisticsGainItem.getBookLanguageId(stack).map(arg_0 -> BookLanguagesPM.LANGUAGES.get().getValue(arg_0)).orElse((BookLanguage)BookLanguagesPM.DEFAULT.get());
    }

    public static ItemStack setBookLanguage(ItemStack stack, BookLanguage lang) {
        stack.m_41784_().m_128359_(TAG_BOOK_LANGUAGE_ID, lang.languageId().toString());
        return stack;
    }

    public ItemStack m_7968_() {
        ItemStack retVal = super.m_7968_();
        LinguisticsGainItem.setBookLanguage(retVal, (BookLanguage)BookLanguagesPM.DEFAULT.get());
        return retVal;
    }

    public Component m_7626_(ItemStack pStack) {
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{LinguisticsGainItem.getBookLanguage(pStack).getName()});
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        BookLanguage lang = LinguisticsGainItem.getBookLanguage(pStack);
        if (lang.isComplex()) {
            if (this.amount >= lang.complexity()) {
                pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.primalmagick.codex.full", (Object[])new Object[]{lang.getName()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.primalmagick.codex.partial", (Object[])new Object[]{lang.getName()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        BookLanguage lang = LinguisticsGainItem.getBookLanguage(pStack);
        return super.m_5812_(pStack) || lang.isComplex() && this.amount >= lang.complexity();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.f_46443_) {
            BookLanguage lang;
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                PacketHandler.sendToPlayer(new PlayClientSoundPacket((SoundEvent)SoundsPM.WRITING.get(), 1.0f, 1.0f + (float)pPlayer.m_217043_().m_188583_() * 0.05f), serverPlayer);
            }
            if (LinguisticsManager.getComprehension(pPlayer, lang = LinguisticsGainItem.getBookLanguage(pPlayer.m_21120_(pUsedHand))) >= lang.complexity()) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.linguistics_item.fluent").m_130940_(ChatFormatting.RED), true);
            } else {
                LinguisticsManager.incrementComprehension(pPlayer, lang, this.amount);
                pPlayer.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.linguistics_item.success").m_130940_(ChatFormatting.GREEN), true);
                if (!pPlayer.m_150110_().f_35937_) {
                    pPlayer.m_21120_(pUsedHand).m_41774_(1);
                }
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public static void registerCreativeTabItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output, Supplier<? extends ItemLike> itemSupplier) {
        Item item = itemSupplier.get().m_5456_();
        params.f_268485_().m_254861_(RegistryKeysPM.BOOK_LANGUAGES).ifPresent(registryLookup -> registryLookup.m_255348_(BookLanguage::isComplex).m_214062_().map(langRef -> LinguisticsGainItem.setBookLanguage(new ItemStack((ItemLike)item), (BookLanguage)langRef.m_203334_())).forEach(stack -> output.m_246342_(stack)));
    }
}

