/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.books;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookHelper;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BookType;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenStaticBookScreenPacket;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class StaticBookItem
extends Item {
    public static final String TAG_BOOK_ID = "BookId";
    public static final String TAG_BOOK_LANGUAGE_ID = "BookLanguageId";
    public static final String TAG_AUTHOR_OVERRIDE = "AuthorOverride";
    public static final String TAG_COMPREHENSION = "Comprehension";
    public static final String TAG_GENERATION = "Generation";
    public static final int MAX_GENERATION = 2;
    protected static final DecimalFormat COMPREHENSION_FORMATTER = new DecimalFormat("###.#");
    protected static final Map<BookType, StaticBookItem> TYPE_MAP = new HashMap<BookType, StaticBookItem>();
    protected final ResourceLocation bgTexture;

    public StaticBookItem(BookType type, Item.Properties properties) {
        super(properties);
        this.bgTexture = type.getBackgroundTexture();
        TYPE_MAP.put(type, this);
    }

    public static ItemStack make(BookType type, Optional<BookDefinition> bookDefOpt, Optional<BookLanguage> bookLangOpt, Optional<String> authorOpt, OptionalInt generationOpt, OptionalInt translationOpt) {
        ItemStack retVal = new ItemStack((ItemLike)TYPE_MAP.get((Object)type));
        bookDefOpt.ifPresent(bookDef -> StaticBookItem.setBookDefinition(retVal, bookDef));
        bookLangOpt.ifPresent(bookLang -> StaticBookItem.setBookLanguage(retVal, bookLang));
        authorOpt.ifPresent(authorOverride -> StaticBookItem.setAuthorOverride(retVal, authorOverride));
        generationOpt.ifPresent(generation -> StaticBookItem.setGeneration(retVal, generation));
        StaticBookItem.setTranslatedComprehension(retVal, translationOpt);
        return retVal;
    }

    protected static MutableComponent getStaticAttribute(ResourceLocation bookId, String attrName) {
        return Component.m_237115_((String)String.join((CharSequence)".", "written_book", bookId.m_135827_(), bookId.m_135815_(), attrName));
    }

    public static Optional<ResourceLocation> getBookId(ItemStack stack) {
        String str;
        CompoundTag rootTag = stack.m_41783_();
        if (rootTag != null && !StringUtil.m_14408_((String)(str = rootTag.m_128461_(TAG_BOOK_ID)))) {
            return Optional.ofNullable(ResourceLocation.m_135820_((String)str));
        }
        return Optional.empty();
    }

    public static boolean hasBookDefinition(ItemStack stack) {
        return StaticBookItem.getBookId(stack).isPresent();
    }

    public static BookDefinition getBookDefinition(ItemStack stack) {
        return StaticBookItem.getBookId(stack).map(arg_0 -> BooksPM.BOOKS.get().getValue(arg_0)).orElse((BookDefinition)BooksPM.TEST_BOOK.get());
    }

    public static ItemStack setBookDefinition(ItemStack stack, BookDefinition def) {
        stack.m_41784_().m_128359_(TAG_BOOK_ID, def.bookId().toString());
        return stack;
    }

    protected static Optional<ResourceLocation> getBookLanguageId(ItemStack stack) {
        String str;
        CompoundTag rootTag = stack.m_41783_();
        if (rootTag != null && !StringUtil.m_14408_((String)(str = rootTag.m_128461_(TAG_BOOK_LANGUAGE_ID)))) {
            return Optional.ofNullable(ResourceLocation.m_135820_((String)str));
        }
        return Optional.empty();
    }

    public static boolean hasBookLanguage(ItemStack stack) {
        return StaticBookItem.getBookLanguageId(stack).isPresent();
    }

    public static BookLanguage getBookLanguage(ItemStack stack) {
        return StaticBookItem.getBookLanguageId(stack).map(arg_0 -> BookLanguagesPM.LANGUAGES.get().getValue(arg_0)).orElse((BookLanguage)BookLanguagesPM.DEFAULT.get());
    }

    public static ItemStack setBookLanguage(ItemStack stack, BookLanguage lang) {
        stack.m_41784_().m_128359_(TAG_BOOK_LANGUAGE_ID, lang.languageId().toString());
        return stack;
    }

    protected static Component getNameFromBookId(ResourceLocation bookId) {
        return StaticBookItem.getStaticAttribute(bookId, "title");
    }

    public static boolean hasAuthor(ItemStack stack) {
        return stack.m_41782_() && (!StringUtil.m_14408_((String)stack.m_41783_().m_128461_(TAG_AUTHOR_OVERRIDE)) || !StringUtil.m_14408_((String)stack.m_41783_().m_128461_(TAG_BOOK_ID)));
    }

    public static Component getAuthor(ItemStack stack) {
        String authorOverride;
        CompoundTag rootTag = stack.m_41783_();
        if (rootTag != null && !StringUtil.m_14408_((String)(authorOverride = rootTag.m_128461_(TAG_AUTHOR_OVERRIDE)))) {
            return Component.m_237113_((String)authorOverride);
        }
        return (Component)StaticBookItem.getBookId(stack).map(StaticBookItem::getAuthorFromBookId).orElse(Component.m_237115_((String)"tooltip.primalmagick.written_book.author.unknown"));
    }

    protected static MutableComponent getAuthorFromBookId(ResourceLocation bookId) {
        return StaticBookItem.getStaticAttribute(bookId, "author");
    }

    public static ItemStack setAuthorOverride(ItemStack stack, String name) {
        stack.m_41784_().m_128359_(TAG_AUTHOR_OVERRIDE, name);
        return stack;
    }

    public static OptionalInt getTranslatedComprehension(ItemStack stack) {
        CompoundTag rootTag = stack.m_41783_();
        return rootTag == null ? OptionalInt.empty() : OptionalInt.of(rootTag.m_128451_(TAG_COMPREHENSION));
    }

    public static ItemStack setTranslatedComprehension(ItemStack stack, OptionalInt comprehensionOpt) {
        comprehensionOpt.ifPresentOrElse(comprehension -> stack.m_41784_().m_128405_(TAG_COMPREHENSION, comprehension), () -> stack.m_41784_().m_128473_(TAG_COMPREHENSION));
        return stack;
    }

    public static int getGeneration(ItemStack stack) {
        CompoundTag rootTag = stack.m_41783_();
        return rootTag == null ? 0 : rootTag.m_128451_(TAG_GENERATION);
    }

    public static ItemStack setGeneration(ItemStack stack, int newGeneration) {
        stack.m_41784_().m_128405_(TAG_GENERATION, newGeneration);
        return stack;
    }

    private static BookView makeBookView(ItemStack pStack) {
        Player player = FMLEnvironment.dist.isClient() ? ClientUtils.getCurrentPlayer() : null;
        ResourceKey bookKey = ResourceKey.m_135785_(RegistryKeysPM.BOOKS, (ResourceLocation)StaticBookItem.getBookId(pStack).get());
        BookLanguage language = StaticBookItem.getBookLanguage(pStack);
        int comprehension = Math.max(player == null ? 0 : LinguisticsManager.getComprehension(player, language), StaticBookItem.getTranslatedComprehension(pStack).orElse(0));
        return new BookView(bookKey, language.languageId(), comprehension);
    }

    public Component m_7626_(ItemStack pStack) {
        if (FMLEnvironment.dist.isClient() && StaticBookItem.getBookId(pStack).isPresent()) {
            return BookHelper.getTitleText(StaticBookItem.makeBookView(pStack));
        }
        return super.m_7626_(pStack);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        BookLanguage lang = StaticBookItem.getBookLanguage(pStack);
        if (pLevel.f_46443_ && StaticBookItem.hasAuthor(pStack)) {
            Component authorText = BookHelper.getAuthorText(StaticBookItem.makeBookView(pStack), StaticBookItem.getAuthor(pStack));
            pTooltipComponents.add((Component)Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{authorText}).m_130940_(ChatFormatting.GRAY));
        }
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.primalmagick.written_language.header", (Object[])new Object[]{lang.getName()}).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)("book.generation." + StaticBookItem.getGeneration(pStack))).m_130940_(ChatFormatting.GRAY));
        if (pLevel.f_46443_ && StaticBookItem.hasBookDefinition(pStack) && StaticBookItem.hasBookLanguage(pStack) && lang.isComplex()) {
            Player player = FMLEnvironment.dist.isClient() ? ClientUtils.getCurrentPlayer() : null;
            BookDefinition def = StaticBookItem.getBookDefinition(pStack);
            OptionalInt translatedComprehension = StaticBookItem.getTranslatedComprehension(pStack);
            int comprehension = Math.max(translatedComprehension.orElse(0), LinguisticsManager.getComprehension(player, lang));
            double percentage = BookHelper.getBookComprehension(new BookView((ResourceKey)BooksPM.BOOKS.get().getResourceKey((Object)def).orElseThrow(), lang.languageId(), comprehension));
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.primalmagick.written_language.comprehension", (Object[])new Object[]{COMPREHENSION_FORMATTER.format(100.0 * percentage)}).m_130940_(ChatFormatting.GRAY));
            if (translatedComprehension.isPresent()) {
                if (translatedComprehension.getAsInt() >= lang.complexity()) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.primalmagick.written_language.translated.full").m_130940_(ChatFormatting.DARK_AQUA));
                } else if (translatedComprehension.getAsInt() > 0) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.primalmagick.written_language.translated.partial").m_130940_(ChatFormatting.DARK_AQUA));
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_ && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            PacketHandler.sendToPlayer(new OpenStaticBookScreenPacket(stack, this.bgTexture), serverPlayer);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

