/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.concoctions;

import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.entities.projectiles.AlchemicalBombEntity;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AlchemicalBombItem
extends Item {
    public AlchemicalBombItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack m_7968_() {
        return ConcoctionUtils.setFuseType(ConcoctionUtils.setConcoctionType(PotionUtils.m_43549_((ItemStack)super.m_7968_(), (Potion)Potions.f_43599_), ConcoctionType.BOMB), FuseType.MEDIUM);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_36341_()) {
            FuseType fuse = ConcoctionUtils.getFuseType(stack);
            if (!worldIn.f_46443_ && fuse != null && fuse.getNext() != null) {
                playerIn.m_21008_(handIn, ConcoctionUtils.setFuseType(stack, fuse.getNext()));
                MutableComponent fuseText = Component.m_237115_((String)fuse.getNext().getTranslationKey());
                playerIn.m_213846_((Component)Component.m_237110_((String)"concoctions.primalmagick.fuse_set", (Object[])new Object[]{fuseText}));
            }
        } else {
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f / (worldIn.m_213780_().m_188501_() * 0.4f + 0.8f));
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            AlchemicalBombEntity entity = new AlchemicalBombEntity(worldIn, (LivingEntity)playerIn);
            entity.m_37446_(stack);
            entity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -20.0f, 0.5f, 1.0f);
            worldIn.m_7967_((Entity)entity);
            StatsManager.incrementValue(playerIn, StatsPM.CONCOCTIONS_USED);
            if (!playerIn.m_150110_().f_35937_) {
                int charges = ConcoctionUtils.getCurrentDoses(stack);
                if (charges <= 1) {
                    stack.m_41774_(1);
                } else {
                    ConcoctionUtils.setCurrentDoses(stack, charges - 1);
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.m_5776_());
    }

    public String m_5671_(ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        ConcoctionType type = ConcoctionUtils.getConcoctionType(stack);
        if (type == null) {
            potion = Potions.f_43598_;
            type = ConcoctionType.WATER;
        }
        return potion.m_43492_(this.m_5524_() + "." + type.m_7912_() + ".effect.");
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        PotionUtils.m_43555_((ItemStack)stack, tooltip, (float)1.0f);
        tooltip.add((Component)Component.m_237110_((String)"concoctions.primalmagick.charges_remaining", (Object[])new Object[]{ConcoctionUtils.getCurrentDoses(stack)}).m_130940_(MobEffectCategory.BENEFICIAL.m_19497_()));
        FuseType fuse = ConcoctionUtils.getFuseType(stack);
        if (fuse == null) {
            fuse = FuseType.MEDIUM;
        }
        MutableComponent fuseText = Component.m_237115_((String)fuse.getTranslationKey()).m_130940_(MobEffectCategory.BENEFICIAL.m_19497_());
        tooltip.add((Component)Component.m_237110_((String)"concoctions.primalmagick.fuse_length", (Object[])new Object[]{fuseText}).m_130940_(MobEffectCategory.BENEFICIAL.m_19497_()));
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || !PotionUtils.m_43547_((ItemStack)stack).isEmpty();
    }

    public static void registerCreativeTabItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output, Supplier<? extends ItemLike> itemSupplier) {
        Item item = itemSupplier.get().m_5456_();
        output.m_246342_(item.m_7968_());
        params.f_268485_().m_254861_(Registries.f_256973_).ifPresent(registryLookup -> registryLookup.m_214062_().filter(potionRef -> !((Potion)potionRef.m_203334_()).m_43488_().isEmpty()).map(potionRef -> ConcoctionUtils.setFuseType(ConcoctionUtils.setConcoctionType(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)((Potion)potionRef.m_203334_())), ConcoctionType.BOMB), FuseType.MEDIUM)).forEach(stack -> output.m_246342_(stack)));
    }
}

