/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.entities;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.entities.misc.FlyingCarpetEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FlyingCarpetItem
extends Item {
    public static final ResourceLocation COLOR_PROPERTY = PrimalMagick.resource("color");
    public static final CauldronInteraction DYED_CARPET = (state, level, pos, player, hand, stack) -> {
        Item item = stack.m_41720_();
        if (!(item instanceof FlyingCarpetItem)) {
            return InteractionResult.PASS;
        }
        FlyingCarpetItem carpet = (FlyingCarpetItem)item;
        if (carpet.getDyeColor(stack) == null) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            carpet.removeDyeColor(stack);
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public FlyingCarpetItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack dyeCarpet(ItemStack carpetStack, DyeItem dye) {
        if (carpetStack.m_41720_() instanceof FlyingCarpetItem) {
            ItemStack retVal = carpetStack.m_41777_();
            ((FlyingCarpetItem)retVal.m_41720_()).setDyeColor(retVal, dye.m_41089_());
            return retVal;
        }
        return ItemStack.f_41583_;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.f_46443_) {
            if (context.m_43719_() != Direction.UP) {
                return InteractionResult.PASS;
            }
            ItemStack stack = context.m_43722_();
            double posX = context.m_43720_().f_82479_;
            double posY = context.m_43720_().f_82480_;
            double posZ = context.m_43720_().f_82481_;
            FlyingCarpetEntity entityCarpet = new FlyingCarpetEntity(world, posX, posY, posZ);
            if (stack.m_41782_()) {
                entityCarpet.setDyeColor(this.getDyeColor(stack));
            }
            entityCarpet.m_146922_(context.m_43723_().m_146908_());
            world.m_7967_((Entity)entityCarpet);
            world.m_6263_(null, posX, posY, posZ, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public DyeColor getDyeColor(ItemStack stack) {
        CompoundTag displayNbt;
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()) != null && nbt.m_128425_("display", 10) && (displayNbt = nbt.m_128469_("display")) != null && displayNbt.m_128425_("color", 3)) {
            return DyeColor.m_41053_((int)displayNbt.m_128451_("color"));
        }
        return null;
    }

    public void setDyeColor(ItemStack stack, DyeColor color) {
        CompoundTag nbt;
        if (color == null) {
            return;
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (!(nbt = stack.m_41783_()).m_128425_("display", 10)) {
            nbt.m_128365_("display", (Tag)new CompoundTag());
        }
        nbt.m_128469_("display").m_128405_("color", color.m_41060_());
    }

    public void removeDyeColor(ItemStack stack) {
        CompoundTag displayNbt;
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()) != null && nbt.m_128425_("display", 10) && (displayNbt = nbt.m_128469_("display")) != null && displayNbt.m_128425_("color", 3)) {
            displayNbt.m_128473_("color");
        }
    }
}

