/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.essence;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EssenceItem
extends Item {
    protected static final Table<EssenceType, Source, Item> ESSENCES = HashBasedTable.create();
    protected final EssenceType type;
    protected final Source source;

    public EssenceItem(@Nonnull EssenceType type, @Nonnull Source source) {
        super(new Item.Properties().m_41497_(type.getRarity()));
        this.type = type;
        this.source = source;
        EssenceItem.register(type, source, this);
    }

    public EssenceType getEssenceType() {
        return this.type;
    }

    public Source getSource() {
        return this.source;
    }

    protected static void register(@Nonnull EssenceType type, @Nonnull Source source, @Nonnull Item item) {
        ESSENCES.put((Object)type, (Object)source, (Object)item);
    }

    @Nonnull
    public static ItemStack getEssence(@Nullable EssenceType type, @Nullable Source source) {
        return EssenceItem.getEssence(type, source, 1);
    }

    @Nonnull
    public static ItemStack getEssence(@Nullable EssenceType type, @Nullable Source source, int count) {
        Item item = (Item)ESSENCES.get((Object)type, (Object)source);
        return item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item, count);
    }

    public static Collection<Item> getAllEssences() {
        return Collections.unmodifiableCollection(ESSENCES.values());
    }
}

