/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.essence;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;

public enum EssenceType implements StringRepresentable
{
    DUST("dust", Rarity.COMMON, 5, 1),
    SHARD("shard", Rarity.UNCOMMON, 20, 10),
    CRYSTAL("crystal", Rarity.RARE, 50, 100),
    CLUSTER("cluster", Rarity.EPIC, 100, 1000);

    private static final Supplier<SimpleResearchKey> SHARD_RESEARCH;
    private static final Supplier<SimpleResearchKey> CRYSTAL_RESEARCH;
    private static final Supplier<SimpleResearchKey> CLUSTER_RESEARCH;
    private final String name;
    private final Rarity rarity;
    private final int affinity;
    private final int mana;

    private EssenceType(String name, Rarity rarity, int affinity, int mana) {
        this.name = name;
        this.rarity = rarity;
        this.affinity = affinity;
        this.mana = mana;
    }

    @Nonnull
    public String m_7912_() {
        return this.name;
    }

    @Nonnull
    public Rarity getRarity() {
        return this.rarity;
    }

    public int getAffinity() {
        return this.affinity;
    }

    public int getManaEquivalent() {
        return this.mana;
    }

    @Nullable
    public EssenceType getUpgrade() {
        switch (this) {
            case DUST: {
                return SHARD;
            }
            case SHARD: {
                return CRYSTAL;
            }
            case CRYSTAL: {
                return CLUSTER;
            }
        }
        return null;
    }

    @Nullable
    public EssenceType getDowngrade() {
        switch (this) {
            case CLUSTER: {
                return CRYSTAL;
            }
            case CRYSTAL: {
                return SHARD;
            }
            case SHARD: {
                return DUST;
            }
        }
        return null;
    }

    @Nullable
    public Item getUpgradeMedium() {
        switch (this) {
            case CLUSTER: {
                return Items.f_42157_;
            }
            case CRYSTAL: {
                return Items.f_42692_;
            }
            case SHARD: {
                return (Item)ItemsPM.QUARTZ_NUGGET.get();
            }
        }
        return null;
    }

    public boolean isDiscovered(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        switch (this) {
            case DUST: {
                return true;
            }
            case SHARD: {
                return SHARD_RESEARCH.get().isKnownByStrict(player);
            }
            case CRYSTAL: {
                return CRYSTAL_RESEARCH.get().isKnownByStrict(player);
            }
            case CLUSTER: {
                return CLUSTER_RESEARCH.get().isKnownByStrict(player);
            }
        }
        return false;
    }

    static {
        SHARD_RESEARCH = ResearchNames.simpleKey(ResearchNames.SHARD_SYNTHESIS);
        CRYSTAL_RESEARCH = ResearchNames.simpleKey(ResearchNames.CRYSTAL_SYNTHESIS);
        CLUSTER_RESEARCH = ResearchNames.simpleKey(ResearchNames.CLUSTER_SYNTHESIS);
    }
}

