/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.food;

import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AmbrosiaItem
extends Item {
    protected static final List<AmbrosiaItem> AMBROSIAS = new ArrayList<AmbrosiaItem>();
    protected static final int BONUS = 2;
    protected static final int PENALTY = -1;
    protected final Source source;
    protected final Type ambrosiaType;

    public AmbrosiaItem(Source source, Type ambrosiaType, Item.Properties properties) {
        super(properties);
        this.source = source;
        this.ambrosiaType = ambrosiaType;
        AMBROSIAS.add(this);
    }

    public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (!worldIn.f_46443_ && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (ResearchManager.isResearchComplete(player, SimpleResearchKey.FIRST_STEPS)) {
                int current;
                int limit = Math.min(this.ambrosiaType.getLimit(), AttunementType.INDUCED.getMaximum());
                int toIncrement = Math.min(2, limit - (current = AttunementManager.getAttunement(player, this.source, AttunementType.INDUCED)));
                if (toIncrement > 0) {
                    for (Source source : Source.SORTED_SOURCES) {
                        if (source == this.source) {
                            AttunementManager.incrementAttunement(player, source, AttunementType.INDUCED, toIncrement);
                            continue;
                        }
                        AttunementManager.incrementAttunement(player, source, AttunementType.INDUCED, -1);
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.ambrosia.success").m_130940_(ChatFormatting.GREEN), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.ambrosia.failure").m_130940_(ChatFormatting.RED), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.ambrosia.not_wizard").m_130940_(ChatFormatting.RED), true);
            }
        }
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    public int getColor(int tintIndex) {
        return tintIndex == 0 ? 0xFFFFFF : this.source.getColor();
    }

    public static Collection<AmbrosiaItem> getAllAmbrosias() {
        return Collections.unmodifiableCollection(AMBROSIAS);
    }

    public static Collection<AmbrosiaItem> getAllAmbrosiasOfType(Type ambrosiaType) {
        return AMBROSIAS.stream().filter(item -> item.ambrosiaType.equals((Object)ambrosiaType)).toList();
    }

    public static enum Type implements StringRepresentable
    {
        BASIC("basic", 10),
        GREATER("greater", 30),
        SUPREME("supreme", 50);

        private final String name;
        private final int limit;

        private Type(String name, int limit) {
            this.name = name;
            this.limit = limit;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public int getLimit() {
            return this.limit;
        }

        @Nullable
        public static Type fromName(@Nullable String name) {
            for (Type ambrosiaType : Type.values()) {
                if (!ambrosiaType.m_7912_().equals(name)) continue;
                return ambrosiaType;
            }
            return null;
        }
    }
}

