/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.renderers.itemstack.ArcanometerISTER;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.ScanEntityPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.ScanItemPacket;
import com.verdantartifice.primalmagick.common.network.packets.misc.ScanPositionPacket;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ArcanometerItem
extends Item {
    public static final ResourceLocation SCAN_STATE_PROPERTY = PrimalMagick.resource("scan_state");

    public ArcanometerItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public static boolean isMouseOverScannable(@Nullable HitResult result, @Nullable Level world, @Nullable Player player) {
        if (result == null || world == null) {
            return false;
        }
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).m_82443_();
            ItemStack stack = EntityUtils.getEntityItemStack(entity);
            if (!stack.m_41619_()) {
                return !ResearchManager.isScanned(stack, player);
            }
            return !ResearchManager.isScanned(entity.m_6095_(), player);
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)result).m_82425_();
            ItemStack stack = new ItemStack((ItemLike)world.m_8055_(pos).m_60734_());
            return !stack.m_41619_() && !ResearchManager.isScanned(stack, player);
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        HitResult result;
        if (worldIn.f_46443_ && (result = RayTraceUtils.getMouseOver(worldIn)) != null && result.m_6662_() != HitResult.Type.MISS) {
            worldIn.m_5594_(playerIn, playerIn.m_20183_(), (SoundEvent)SoundsPM.SCAN.get(), SoundSource.MASTER, 1.0f, 1.0f);
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                Entity entity = ((EntityHitResult)result).m_82443_();
                ItemStack entityStack = EntityUtils.getEntityItemStack(entity);
                if (!entityStack.m_41619_()) {
                    PacketHandler.sendToServer(new ScanItemPacket(entityStack));
                } else {
                    PacketHandler.sendToServer(new ScanEntityPacket(entity.m_6095_()));
                }
            } else if (result.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = ((BlockHitResult)result).m_82425_();
                PacketHandler.sendToServer(new ScanPositionPacket(pos));
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final BlockEntityWithoutLevelRenderer renderer = new ArcanometerISTER();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

