/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class AttunementShacklesItem
extends Item {
    protected static final Map<Source, AttunementShacklesItem> SHACKLES = new HashMap<Source, AttunementShacklesItem>();
    protected final Source source;

    public AttunementShacklesItem(Source source, Item.Properties properties) {
        super(properties);
        this.source = source;
        SHACKLES.put(source, this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.f_46443_) {
            AttunementManager.setSuppressed(pPlayer, this.source, !AttunementManager.isSuppressed(pPlayer, this.source));
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        Player player;
        super.m_7373_(stack, level, tooltip, flagIn);
        Object object = player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
        if (AttunementManager.isSuppressed(player, this.source)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.primalmagick.active").m_130940_(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.primalmagick.inactive").m_130940_(ChatFormatting.RED));
        }
    }

    public int getColor(int tintIndex) {
        return tintIndex == 0 ? 0xFFFFFF : this.source.getColor();
    }

    @Nullable
    public static AttunementShacklesItem getShackles(Source source) {
        return SHACKLES.getOrDefault(source, null);
    }

    public static Collection<AttunementShacklesItem> getAllShackles() {
        return Collections.unmodifiableCollection(SHACKLES.values());
    }
}

