/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.blocks.rituals.OfferingPedestalBlock;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.PropMarkerPacket;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropTileEntity;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import com.verdantartifice.primalmagick.common.tiles.rituals.OfferingPedestalTileEntity;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualAltarTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DowsingRodItem
extends Item {
    protected static final float THRESHOLD_HIGH = 0.15f;
    protected static final float THRESHOLD_LOW = 0.025f;

    public DowsingRodItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!level.f_46443_) {
            ItemStack stack = context.m_43722_();
            BlockPos targetPos = context.m_8083_();
            Block block = level.m_8055_(targetPos).m_60734_();
            BlockEntity blockEntity = level.m_7702_(targetPos);
            Player player = context.m_43723_();
            if (blockEntity instanceof RitualAltarTileEntity) {
                RitualAltarTileEntity altarEntity = (RitualAltarTileEntity)blockEntity;
                this.doStabilityCheck(altarEntity, player);
                this.damageRod(player, stack);
                return InteractionResult.SUCCESS;
            }
            if (block instanceof OfferingPedestalBlock) {
                OfferingPedestalBlock pedestalBlock = (OfferingPedestalBlock)block;
                if (blockEntity instanceof OfferingPedestalTileEntity) {
                    OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)blockEntity;
                    this.doPropSaltCheck(level, pedestalBlock, targetPos, player);
                    this.doPropSymmetryCheck(level, pedestalBlock, targetPos, pedestalTile.getAltarPos(), player);
                    this.damageRod(player, stack);
                    return InteractionResult.SUCCESS;
                }
            }
            if (block instanceof IRitualPropBlock) {
                IRitualPropBlock propBlock = (IRitualPropBlock)block;
                if (blockEntity instanceof IRitualPropTileEntity) {
                    IRitualPropTileEntity propTile = (IRitualPropTileEntity)blockEntity;
                    this.doPropSaltCheck(level, propBlock, targetPos, player);
                    this.doPropSymmetryCheck(level, propBlock, targetPos, propTile.getAltarPos(), player);
                    this.damageRod(player, stack);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    protected void doStabilityCheck(RitualAltarTileEntity altarEntity, Player player) {
        float delta = altarEntity.calculateStabilityDelta();
        if (delta >= 0.15f) {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.altar_stability.very_good"));
        } else if (delta >= 0.025f) {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.altar_stability.good"));
        } else if (delta <= -0.15f) {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.altar_stability.very_poor"));
        } else if (delta <= -0.025f) {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.altar_stability.poor"));
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.altar_stability.neutral"));
        }
    }

    protected void doPropSaltCheck(Level level, ISaltPowered block, BlockPos blockPos, Player player) {
        if (block.isBlockSaltPowered((BlockGetter)level, blockPos)) {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.salt_connection.active"));
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.salt_connection.inactive"));
        }
    }

    protected void doPropSymmetryCheck(Level level, IRitualStabilizer block, BlockPos blockPos, BlockPos altarPos, Player player) {
        BlockPos symPos = RitualAltarTileEntity.getSymmetricPosition(altarPos, blockPos);
        if (symPos == null || block.hasSymmetryPenalty(level, blockPos, symPos)) {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.symmetry.not_found"));
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.symmetry.marking_pos"));
                PacketHandler.sendToPlayer(new PropMarkerPacket(symPos, 200), serverPlayer);
            }
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.dowsing_rod.symmetry.found"));
        }
    }

    protected void damageRod(Player player, ItemStack stack) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
        }
    }
}

