/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DreamVisionTalismanItem
extends Item {
    protected static final int CAPACITY = 64;

    public DreamVisionTalismanItem() {
        super(new Item.Properties().m_41503_(64));
    }

    public int getStoredExp(ItemStack stack) {
        return stack.m_41784_().m_128451_("StoredExp");
    }

    public int addStoredExp(ItemStack stack, int toAdd) {
        int max;
        int current = this.getStoredExp(stack);
        if (current + toAdd <= (max = this.getExpCapacity(stack))) {
            this.setStoredExp(stack, current + toAdd);
            return 0;
        }
        int leftover = current + toAdd - max;
        this.setStoredExp(stack, max);
        return leftover;
    }

    protected void setStoredExp(ItemStack stack, int toSet) {
        stack.m_41784_().m_128405_("StoredExp", toSet);
    }

    public int getExpCapacity(ItemStack stack) {
        return 64;
    }

    public boolean isActive(ItemStack stack) {
        return !stack.m_41784_().m_128471_("Disabled");
    }

    public void setActive(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("Disabled", !active);
    }

    public boolean isReadyToDrain(ItemStack stack) {
        DreamVisionTalismanItem talisman;
        Item item;
        return stack != null && (item = stack.m_41720_()) instanceof DreamVisionTalismanItem && (talisman = (DreamVisionTalismanItem)item).getStoredExp(stack) >= talisman.getExpCapacity(stack);
    }

    public boolean doDrain(ItemStack stack, Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && this.isReadyToDrain(stack) && ResearchManager.addKnowledge(player, KnowledgeType.OBSERVATION, KnowledgeType.OBSERVATION.getProgression())) {
            this.setStoredExp(stack, 0);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.dream_vision_talisman.break").m_130940_(ChatFormatting.RED), false));
            return true;
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.primalmagick.dream_vision_talisman.exp", (Object[])new Object[]{this.getStoredExp(stack), this.getExpCapacity(stack)}));
        if (this.isActive(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.primalmagick.active").m_130940_(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.primalmagick.inactive").m_130940_(ChatFormatting.RED));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return this.isReadyToDrain(stack) || super.m_5812_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean active = this.isActive(stack);
        if (level.f_46443_) {
            if (active) {
                player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.dream_vision_talisman.set_inactive"), false);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.dream_vision_talisman.set_active"), false);
            }
        }
        this.setActive(stack, !active);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }
}

