/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.misc;

import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import com.verdantartifice.primalmagick.common.entities.companions.pixies.AbstractPixieEntity;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeSpawnEggItem;

public class PixieItem
extends ForgeSpawnEggItem {
    protected static final List<PixieItem> PIXIES = new ArrayList<PixieItem>();

    public PixieItem(Supplier<EntityType<? extends AbstractPixieEntity>> typeSupplier, Source source, Item.Properties properties) {
        super(typeSupplier, 0xFFFFFF, source.getColor(), properties);
        PIXIES.add(this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level instanceof ServerLevel) {
            BlockPos spawnPos;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack stack = context.m_43722_();
            BlockPos pos = context.m_8083_();
            Direction dir = context.m_43719_();
            BlockState state = level.m_8055_(pos);
            Player player = context.m_43723_();
            EntityType entityType = this.m_43228_(stack.m_41783_());
            Entity spawned = entityType.m_20592_(serverLevel, stack, player, spawnPos = state.m_60812_((BlockGetter)level, pos).m_83281_() ? pos : pos.m_121945_(dir), MobSpawnType.SPAWN_EGG, true, !Objects.equals(pos, spawnPos) && dir == Direction.UP);
            if (spawned != null) {
                stack.m_41774_(1);
                level.m_142346_((Entity)player, GameEvent.f_157810_, pos);
                if (spawned instanceof AbstractPixieEntity) {
                    AbstractPixieEntity pixie = (AbstractPixieEntity)spawned;
                    CompanionManager.addCompanion(player, pixie);
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public static Collection<PixieItem> getAllPixies() {
        return Collections.unmodifiableCollection(PIXIES);
    }
}

