/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.verdantartifice.primalmagick.common.entities.projectiles.AbstractTridentEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractTieredTridentItem
extends TridentItem {
    protected final Tier tier;
    protected final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public AbstractTieredTridentItem(Tier tier, Item.Properties properties) {
        super(properties.m_41499_(tier.m_6609_()));
        this.tier = tier;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 7.0 + (double)tier.m_6631_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public Tier getTier() {
        return this.tier;
    }

    public int m_6473_() {
        return this.tier.m_6601_();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.tier.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    protected abstract AbstractTridentEntity getThrownEntity(Level var1, LivingEntity var2, ItemStack var3);

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            int riptide;
            Player player = (Player)entityLiving;
            int duration = this.m_8105_(stack) - timeLeft;
            if (duration >= 10 && ((riptide = EnchantmentHelper.m_44932_((ItemStack)stack)) <= 0 || player.m_20070_())) {
                if (!worldIn.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(entityLiving.m_7655_()));
                    if (riptide == 0) {
                        AbstractTridentEntity trident = this.getThrownEntity(worldIn, (LivingEntity)player, stack);
                        trident.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)riptide * 0.5f, 1.0f);
                        if (player.m_150110_().f_35937_) {
                            trident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.m_7967_((Entity)trident);
                        worldIn.m_6269_((Player)null, (Entity)trident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            player.m_150109_().m_36057_(stack);
                        }
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                if (riptide > 0) {
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)riptide) / 4.0f);
                    player.m_5997_((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999, 0.0));
                    }
                    SoundEvent sound = riptide >= 3 ? SoundEvents.f_12519_ : (riptide == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    worldIn.m_6269_((Player)null, (Entity)player, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }
}

