/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.crafting.IWandTransform;
import com.verdantartifice.primalmagick.common.crafting.WandTransforms;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.armor.IManaDiscountGear;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class AbstractWandItem
extends Item
implements IWand {
    protected static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");

    public AbstractWandItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getMana(ItemStack stack, Source source) {
        if (this.getMaxMana(stack) == -1) {
            return -1;
        }
        int retVal = 0;
        if (stack != null && source != null && stack.m_41782_() && stack.m_41783_().m_128441_(source.getTag())) {
            retVal = stack.m_41783_().m_128451_(source.getTag());
        }
        return retVal;
    }

    @Override
    public MutableComponent getManaText(ItemStack stack, Source source) {
        int mana = this.getMana(stack, source);
        if (mana == -1) {
            return Component.m_237113_((String)Character.toString('\u221e'));
        }
        return Component.m_237113_((String)MANA_FORMATTER.format((double)mana / 100.0));
    }

    @Override
    public SourceList getAllMana(ItemStack stack) {
        SourceList retVal = SourceList.EMPTY;
        boolean isInfinite = this.getMaxMana(stack) == -1;
        for (Source source : Source.SORTED_SOURCES) {
            if (isInfinite) {
                retVal = retVal.set(source, -1);
                continue;
            }
            if (stack.m_41782_() && stack.m_41783_().m_128441_(source.getTag())) {
                retVal = retVal.merge(source, stack.m_41783_().m_128451_(source.getTag()));
                continue;
            }
            retVal = retVal.merge(source, 0);
        }
        return retVal;
    }

    @Override
    public MutableComponent getMaxManaText(ItemStack stack) {
        int mana = this.getMaxMana(stack);
        if (mana == -1) {
            return Component.m_237113_((String)Character.toString('\u221e'));
        }
        return Component.m_237113_((String)MANA_FORMATTER.format((double)mana / 100.0));
    }

    protected void setMana(@Nonnull ItemStack stack, @Nonnull Source source, int amount) {
        stack.m_41700_(source.getTag(), (Tag)IntTag.m_128679_((int)amount));
    }

    @Override
    public int addRealMana(ItemStack stack, Source source, int amount) {
        int leftoverCentimana = this.addMana(stack, source, amount * 100, this.getMaxMana(stack));
        return (int)((double)leftoverCentimana / 100.0);
    }

    protected int addMana(ItemStack stack, Source source, int amount, int max) {
        if (stack == null || source == null || this.getMaxMana(stack) == -1) {
            return 0;
        }
        int toStore = this.getMana(stack, source) + amount;
        int leftover = Math.max(toStore - max, 0);
        this.setMana(stack, source, Math.min(toStore, max));
        return leftover;
    }

    @Override
    public boolean consumeMana(ItemStack stack, Player player, Source source, int amount) {
        if (stack == null || source == null) {
            return false;
        }
        if (this.containsMana(stack, player, source, amount)) {
            if (this.getMaxMana(stack) != -1) {
                this.setMana(stack, source, this.getMana(stack, source) - (amount == 0 ? 0 : Math.max(1, (int)(this.getTotalCostModifier(stack, player, source) * (double)amount))));
            }
            if (player != null) {
                int realAmount = amount / 100;
                StatsManager.incrementValue(player, StatsPM.MANA_SPENT_TOTAL, realAmount);
                StatsManager.incrementValue(player, source.getManaSpentStat(), realAmount);
                AttunementManager.incrementAttunement(player, source, AttunementType.TEMPORARY, Mth.m_14107_((double)Math.sqrt(realAmount)));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean consumeMana(ItemStack stack, Player player, SourceList sources) {
        if (stack == null || sources == null) {
            return false;
        }
        if (this.containsMana(stack, player, sources)) {
            boolean isInfinite = this.getMaxMana(stack) == -1;
            SourceList.Builder deltaBuilder = SourceList.builder();
            for (Source source : sources.getSources()) {
                int amount = sources.getAmount(source);
                int realAmount = amount / 100;
                if (!isInfinite) {
                    this.setMana(stack, source, this.getMana(stack, source) - (int)(this.getTotalCostModifier(stack, player, source) * (double)amount));
                }
                if (player != null) {
                    StatsManager.incrementValue(player, StatsPM.MANA_SPENT_TOTAL, realAmount);
                    StatsManager.incrementValue(player, source.getManaSpentStat(), realAmount);
                }
                deltaBuilder.with(source, Mth.m_14107_((double)Math.sqrt(realAmount)));
            }
            SourceList attunementDeltas = deltaBuilder.build();
            if (player != null && !attunementDeltas.isEmpty()) {
                AttunementManager.incrementAttunement(player, AttunementType.TEMPORARY, attunementDeltas);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean consumeRealMana(ItemStack stack, Player player, Source source, int amount) {
        return this.consumeMana(stack, player, source, amount * 100);
    }

    @Override
    public boolean consumeRealMana(ItemStack stack, Player player, SourceList sources) {
        return this.consumeMana(stack, player, sources.multiply(100));
    }

    @Override
    public boolean removeManaRaw(ItemStack stack, Source source, int amount) {
        if (stack == null || source == null) {
            return false;
        }
        if (this.containsManaRaw(stack, source, amount)) {
            if (this.getMaxMana(stack) != -1) {
                this.setMana(stack, source, this.getMana(stack, source) - (amount == 0 ? 0 : Math.max(1, amount)));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean containsMana(ItemStack stack, Player player, Source source, int amount) {
        return this.getMaxMana(stack) == -1 || this.getMana(stack, source) >= (int)Math.floor(this.getTotalCostModifier(stack, player, source) * (double)amount);
    }

    @Override
    public boolean containsMana(ItemStack stack, Player player, SourceList sources) {
        for (Source source : sources.getSources()) {
            if (this.containsMana(stack, player, source, sources.getAmount(source))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsRealMana(ItemStack stack, Player player, Source source, int amount) {
        return this.containsMana(stack, player, source, amount * 100);
    }

    @Override
    public boolean containsRealMana(ItemStack stack, Player player, SourceList sources) {
        return this.containsMana(stack, player, sources.multiply(100));
    }

    @Override
    public boolean containsManaRaw(ItemStack stack, Source source, int amount) {
        return this.getMaxMana(stack) == -1 || this.getMana(stack, source) >= amount;
    }

    @Override
    public double getTotalCostModifier(ItemStack stack, @Nullable Player player, Source source) {
        double modifier = this.getBaseCostModifier(stack);
        int efficiencyLevel = stack.getEnchantmentLevel((Enchantment)EnchantmentsPM.MANA_EFFICIENCY.get());
        if (efficiencyLevel > 0) {
            modifier -= 0.02 * (double)efficiencyLevel;
        }
        if (player != null) {
            int gearDiscount = 0;
            for (ItemStack gearStack : player.m_20158_()) {
                Item item = gearStack.m_41720_();
                if (!(item instanceof IManaDiscountGear)) continue;
                IManaDiscountGear discountItem = (IManaDiscountGear)item;
                gearDiscount += discountItem.getManaDiscount(gearStack, player, source);
            }
            if (gearDiscount > 0) {
                modifier -= 0.01 * (double)gearDiscount;
            }
            if (AttunementManager.meetsThreshold(player, source, AttunementThreshold.MINOR)) {
                modifier -= 0.05;
            }
            if (player.m_21023_((MobEffect)EffectsPM.MANAFRUIT.get())) {
                modifier -= 0.01 * (double)(2 * player.m_21124_((MobEffect)EffectsPM.MANAFRUIT.get()).m_19564_() + 1);
            }
            if (player.m_21023_((MobEffect)EffectsPM.MANA_IMPEDANCE.get())) {
                modifier += 0.05 * (double)(player.m_21124_((MobEffect)EffectsPM.MANA_IMPEDANCE.get()).m_19564_() + 1);
            }
        }
        return modifier;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean showDetails;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Player player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
        boolean bl = showDetails = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.hasShiftDown() : false;
        if (showDetails) {
            for (Source source : Source.SORTED_SOURCES) {
                if (!source.isDiscovered(player)) continue;
                Component nameComp = source.getNameText();
                int modifier = (int)Math.round(100.0 * this.getTotalCostModifier(stack, player, source));
                MutableComponent line = Component.m_237110_((String)"tooltip.primalmagick.source.mana", (Object[])new Object[]{nameComp, this.getManaText(stack, source), this.getMaxManaText(stack), modifier});
                tooltip.add((Component)line);
            }
            List spells = this.getSpells(stack);
            int activeIndex = this.getActiveSpellIndex(stack);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.wand_header", (Object[])new Object[]{this.getSpellCapacityText(stack)}));
            if (spells.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.primalmagick.spells.none"));
            } else {
                for (int index = 0; index < spells.size(); ++index) {
                    SpellPackage spell = (SpellPackage)spells.get(index);
                    if (index == activeIndex) {
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.name_selected", (Object[])new Object[]{spell.getName()}));
                        tooltip.addAll(SpellManager.getSpellPackageDetailTooltip(spell, stack, true));
                        continue;
                    }
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.name_unselected", (Object[])new Object[]{spell.getName()}));
                }
            }
        } else {
            boolean first = true;
            MutableComponent summaryText = Component.m_237113_((String)"");
            for (Source source : Source.SORTED_SOURCES) {
                if (!source.isDiscovered(player)) continue;
                MutableComponent manaText = this.getManaText(stack, source).m_130940_(source.getChatColor());
                summaryText = first ? manaText : Component.m_237110_((String)"tooltip.primalmagick.source.mana_summary_fragment", (Object[])new Object[]{summaryText, manaText});
                first = false;
            }
            tooltip.add((Component)summaryText);
            SpellPackage activeSpell = this.getActiveSpell(stack);
            MutableComponent activeSpellName = activeSpell == null ? Component.m_237115_((String)"tooltip.primalmagick.none") : activeSpell.getName();
            tooltip.add((Component)Component.m_237110_((String)"tooltip.primalmagick.spells.short_wand_header", (Object[])new Object[]{activeSpellName}));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.primalmagick.more_info").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Override
    public BlockPos getPositionInUse(ItemStack wandStack) {
        if (wandStack.m_41782_() && wandStack.m_41783_().m_128441_("UsingX") && wandStack.m_41783_().m_128441_("UsingY") && wandStack.m_41783_().m_128441_("UsingZ")) {
            return new BlockPos(wandStack.m_41783_().m_128451_("UsingX"), wandStack.m_41783_().m_128451_("UsingY"), wandStack.m_41783_().m_128451_("UsingZ"));
        }
        return null;
    }

    @Override
    public void setPositionInUse(ItemStack wandStack, BlockPos pos) {
        wandStack.m_41700_("UsingX", (Tag)IntTag.m_128679_((int)pos.m_123341_()));
        wandStack.m_41700_("UsingY", (Tag)IntTag.m_128679_((int)pos.m_123342_()));
        wandStack.m_41700_("UsingZ", (Tag)IntTag.m_128679_((int)pos.m_123343_()));
    }

    @Override
    public void clearPositionInUse(ItemStack wandStack) {
        if (wandStack.m_41782_()) {
            wandStack.m_41783_().m_128473_("UsingX");
            wandStack.m_41783_().m_128473_("UsingY");
            wandStack.m_41783_().m_128473_("UsingZ");
        }
    }

    protected static boolean isTargetWandInteractable(Level level, Player player, HitResult hit) {
        if (hit != null && hit.m_6662_() == HitResult.Type.BLOCK && hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.m_82425_();
            if (level.m_8055_(pos).m_60734_() instanceof IInteractWithWand || level.m_7702_(pos) instanceof IInteractWithWand) {
                return true;
            }
            return WandTransforms.getAll().stream().anyMatch(t -> t.isValid(level, player, pos));
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        SpellPackage activeSpell = this.getActiveSpell(stack);
        if (activeSpell != null && !SpellManager.isOnCooldown(playerIn)) {
            SpellManager.setCooldown(playerIn, activeSpell.getCooldownTicks());
            if (worldIn.f_46443_) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            BlockHitResult hit = AbstractWandItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (AbstractWandItem.isTargetWandInteractable(worldIn, playerIn, (HitResult)hit)) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (this.consumeRealMana(stack, playerIn, activeSpell.getManaCost())) {
                activeSpell.cast(worldIn, (LivingEntity)playerIn, stack);
                playerIn.m_6674_(handIn);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        context.m_43723_().m_6672_(context.m_43724_());
        BlockState bs = context.m_43725_().m_8055_(context.m_8083_());
        Block block = bs.m_60734_();
        if (block instanceof IInteractWithWand) {
            IInteractWithWand wandable = (IInteractWithWand)block;
            return wandable.onWandRightClick(context.m_43722_(), context.m_43725_(), context.m_43723_(), context.m_8083_(), context.m_43719_());
        }
        BlockEntity tile = context.m_43725_().m_7702_(context.m_8083_());
        if (tile != null && tile instanceof IInteractWithWand) {
            IInteractWithWand wandable = (IInteractWithWand)tile;
            return wandable.onWandRightClick(context.m_43722_(), context.m_43725_(), context.m_43723_(), context.m_8083_(), context.m_43719_());
        }
        for (IWandTransform transform : WandTransforms.getAll()) {
            if (!transform.isValid(context.m_43725_(), context.m_43723_(), context.m_8083_())) continue;
            if (!context.m_43723_().m_36204_(context.m_8083_(), context.m_43719_(), context.m_43722_())) {
                return InteractionResult.FAIL;
            }
            this.setPositionInUse(stack, context.m_8083_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int count) {
        if (living instanceof Player) {
            Object object;
            Player player = (Player)living;
            BlockPos wandPos = this.getPositionInUse(stack);
            if (wandPos != null && (object = level.m_7702_(wandPos)) instanceof IInteractWithWand) {
                IInteractWithWand wandable = (IInteractWithWand)object;
                Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_() / 2.0, 0.0);
                wandable.onWandUseTick(stack, level, player, playerPos, count);
            } else if (wandPos != null) {
                for (IWandTransform transform : WandTransforms.getAll()) {
                    if (!transform.isValid(level, player, wandPos)) continue;
                    if (level.f_46443_) {
                        FxDispatcher.INSTANCE.spellImpact((double)wandPos.m_123341_() + 0.5, (double)wandPos.m_123342_() + 0.5, (double)wandPos.m_123343_() + 0.5, 2, Source.HALLOWED.getColor());
                    }
                    if (this.m_8105_(stack) - count < 40) continue;
                    if (level.f_46443_ || !(player instanceof ServerPlayer)) break;
                    transform.execute(level, player, wandPos);
                    break;
                }
            }
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        Player player;
        super.m_5551_(stack, worldIn, entityLiving, timeLeft);
        SimpleResearchKey hintKey = ((ResearchName)ResearchNames.INTERNAL_WAND_TRANSFORM_HINT.get()).simpleKey();
        BlockPos wandPos = this.getPositionInUse(stack);
        if (wandPos != null && !worldIn.f_46443_ && entityLiving instanceof Player && !hintKey.isKnownByStrict(player = (Player)entityLiving)) {
            for (IWandTransform transform : WandTransforms.getAll()) {
                if (!transform.isValid(worldIn, player, wandPos) || this.m_8105_(stack) - timeLeft >= 40) continue;
                ResearchManager.completeResearch(player, hintKey);
                player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.wand_transform_hint").m_130940_(ChatFormatting.GREEN));
                break;
            }
        }
        this.clearPositionInUse(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }
}

