/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.verdantartifice.primalmagick.client.renderers.itemstack.ModularStaffISTER;
import com.verdantartifice.primalmagick.common.items.wands.ModularWandItem;
import com.verdantartifice.primalmagick.common.wands.IStaff;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ModularStaffItem
extends ModularWandItem
implements IStaff {
    protected final float attackDamage;
    protected final float attackSpeed;
    protected final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ModularStaffItem(int attackDamage, float attackSpeed, Item.Properties properties) {
        super(properties);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        WandCore core = this.getWandCore(stack);
        MutableComponent coreName = core == null ? Component.m_237115_((String)"wand_core.primalmagick.unknown") : Component.m_237115_((String)core.getNameTranslationKey());
        WandCap cap = this.getWandCap(stack);
        MutableComponent capName = cap == null ? Component.m_237115_((String)"wand_cap.primalmagick.unknown") : Component.m_237115_((String)cap.getNameTranslationKey());
        WandGem gem = this.getWandGem(stack);
        MutableComponent gemName = gem == null ? Component.m_237115_((String)"wand_gem.primalmagick.unknown") : Component.m_237115_((String)gem.getNameTranslationKey());
        return Component.m_237110_((String)"item.primalmagick.modular_staff", (Object[])new Object[]{gemName, capName, coreName});
    }

    @Override
    protected int getCoreSpellSlotCount(WandCore core) {
        return core == null ? 0 : 2 * core.getSpellSlots();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final BlockEntityWithoutLevelRenderer renderer = new ModularStaffISTER();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

