/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.verdantartifice.primalmagick.client.renderers.itemstack.ModularWandISTER;
import com.verdantartifice.primalmagick.common.items.wands.AbstractWandItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.wands.IWandComponent;
import com.verdantartifice.primalmagick.common.wands.WandCap;
import com.verdantartifice.primalmagick.common.wands.WandCore;
import com.verdantartifice.primalmagick.common.wands.WandGem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ModularWandItem
extends AbstractWandItem {
    public ModularWandItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        if (stack == null) {
            return 2500;
        }
        WandGem gem = this.getWandGem(stack);
        if (gem == null) {
            return 2500;
        }
        if (gem.getCapacity() == -1) {
            return -1;
        }
        return 100 * gem.getCapacity();
    }

    @Override
    public double getBaseCostModifier(ItemStack stack) {
        if (stack == null) {
            return 1.2;
        }
        WandCap cap = this.getWandCap(stack);
        return cap == null ? 1.2 : cap.getBaseCostModifier();
    }

    @Override
    public int getSiphonAmount(ItemStack stack) {
        if (stack == null) {
            return 1;
        }
        WandCap cap = this.getWandCap(stack);
        return cap == null ? 1 : cap.getSiphonAmount();
    }

    @Override
    public double getTotalCostModifier(ItemStack stack, Player player, Source source) {
        double mod = super.getTotalCostModifier(stack, player, source);
        WandCore core = this.getWandCore(stack);
        if (core != null && core.getAlignedSources().contains(source)) {
            mod -= 0.05;
        }
        return mod;
    }

    @Override
    public boolean isGlamoured(ItemStack stack) {
        return stack.m_41782_() && (stack.m_41783_().m_128441_("coreAppearance") || stack.m_41783_().m_128441_("capAppearance") || stack.m_41783_().m_128441_("gemAppearance"));
    }

    @Nullable
    public WandCore getWandCore(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("core")) {
            return WandCore.getWandCore(stack.m_41783_().m_128461_("core"));
        }
        return null;
    }

    public void setWandCore(@Nonnull ItemStack stack, @Nonnull WandCore core) {
        stack.m_41700_("core", (Tag)StringTag.m_129297_((String)core.getTag()));
    }

    @Nullable
    public WandCore getWandCoreAppearance(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("coreAppearance")) {
            return WandCore.getWandCore(stack.m_41783_().m_128461_("coreAppearance"));
        }
        return this.getWandCore(stack);
    }

    public void setWandCoreAppearance(@Nonnull ItemStack stack, @Nullable WandCore core) {
        if (core == null) {
            stack.m_41749_("coreAppearance");
        } else {
            stack.m_41700_("coreAppearance", (Tag)StringTag.m_129297_((String)core.getTag()));
        }
    }

    @Nullable
    public WandCap getWandCap(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("cap")) {
            return WandCap.getWandCap(stack.m_41783_().m_128461_("cap"));
        }
        return null;
    }

    public void setWandCap(@Nonnull ItemStack stack, @Nonnull WandCap cap) {
        stack.m_41700_("cap", (Tag)StringTag.m_129297_((String)cap.getTag()));
    }

    @Nullable
    public WandCap getWandCapAppearance(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("capAppearance")) {
            return WandCap.getWandCap(stack.m_41783_().m_128461_("capAppearance"));
        }
        return this.getWandCap(stack);
    }

    public void setWandCapAppearance(@Nonnull ItemStack stack, @Nullable WandCap cap) {
        if (cap == null) {
            stack.m_41749_("capAppearance");
        } else {
            stack.m_41700_("capAppearance", (Tag)StringTag.m_129297_((String)cap.getTag()));
        }
    }

    @Nullable
    public WandGem getWandGem(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("gem")) {
            return WandGem.getWandGem(stack.m_41783_().m_128461_("gem"));
        }
        return null;
    }

    public void setWandGem(@Nonnull ItemStack stack, @Nonnull WandGem gem) {
        stack.m_41700_("gem", (Tag)StringTag.m_129297_((String)gem.getTag()));
    }

    @Nullable
    public WandGem getWandGemAppearance(@Nonnull ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("gemAppearance")) {
            return WandGem.getWandGem(stack.m_41783_().m_128461_("gemAppearance"));
        }
        return this.getWandGem(stack);
    }

    public void setWandGemAppearance(@Nonnull ItemStack stack, @Nullable WandGem gem) {
        if (gem == null) {
            stack.m_41749_("gemAppearance");
        } else {
            stack.m_41700_("gemAppearance", (Tag)StringTag.m_129297_((String)gem.getTag()));
        }
    }

    @Nonnull
    protected List<IWandComponent> getComponents(@Nonnull ItemStack stack) {
        return Arrays.asList(this.getWandCore(stack), this.getWandCap(stack), this.getWandGem(stack)).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Component m_7626_(ItemStack stack) {
        WandCore core = this.getWandCore(stack);
        MutableComponent coreName = core == null ? Component.m_237115_((String)"wand_core.primalmagick.unknown") : Component.m_237115_((String)core.getNameTranslationKey());
        WandCap cap = this.getWandCap(stack);
        MutableComponent capName = cap == null ? Component.m_237115_((String)"wand_cap.primalmagick.unknown") : Component.m_237115_((String)cap.getNameTranslationKey());
        WandGem gem = this.getWandGem(stack);
        MutableComponent gemName = gem == null ? Component.m_237115_((String)"wand_gem.primalmagick.unknown") : Component.m_237115_((String)gem.getNameTranslationKey());
        return Component.m_237110_((String)"item.primalmagick.modular_wand", (Object[])new Object[]{gemName, capName, coreName});
    }

    public Rarity m_41460_(ItemStack stack) {
        WandGem gem;
        WandCap cap;
        Rarity retVal = Rarity.COMMON;
        WandCore core = this.getWandCore(stack);
        if (core != null && core.getRarity().compareTo((Enum)retVal) > 0) {
            retVal = core.getRarity();
        }
        if ((cap = this.getWandCap(stack)) != null && cap.getRarity().compareTo((Enum)retVal) > 0) {
            retVal = cap.getRarity();
        }
        if ((gem = this.getWandGem(stack)) != null && gem.getRarity().compareTo((Enum)retVal) > 0) {
            retVal = gem.getRarity();
        }
        if (stack.m_41793_()) {
            switch (retVal) {
                case COMMON: 
                case UNCOMMON: {
                    return Rarity.RARE;
                }
                case RARE: {
                    return Rarity.EPIC;
                }
            }
            return retVal;
        }
        return retVal;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.getComponents(stack).stream().mapToInt(IWandComponent::getEnchantability).sum();
    }

    public static void registerCreativeTabItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output, Supplier<? extends ItemLike> itemSupplier) {
        Item item = itemSupplier.get().m_5456_();
        if (item instanceof ModularWandItem) {
            ModularWandItem wandItem = (ModularWandItem)item;
            ItemStack stack = new ItemStack((ItemLike)wandItem);
            wandItem.setWandCore(stack, WandCore.HEARTWOOD);
            wandItem.setWandCap(stack, WandCap.IRON);
            wandItem.setWandGem(stack, WandGem.APPRENTICE);
            output.m_246342_(stack);
            stack = new ItemStack((ItemLike)wandItem);
            wandItem.setWandCore(stack, WandCore.HEARTWOOD);
            wandItem.setWandCap(stack, WandCap.IRON);
            wandItem.setWandGem(stack, WandGem.CREATIVE);
            output.m_246342_(stack);
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (stack != null && entityIn.f_19797_ % 20 == 0) {
            int maxMana = this.getMaxMana(stack);
            WandCore core = this.getWandCore(stack);
            if (core != null && maxMana != -1) {
                for (Source alignedSource : core.getAlignedSources()) {
                    int curMana = this.getMana(stack, alignedSource);
                    if (!((double)curMana < 0.1 * (double)maxMana)) continue;
                    this.addMana(stack, alignedSource, 100, (int)(0.1 * (double)maxMana));
                }
            }
        }
    }

    protected int getCoreSpellSlotCount(@Nullable WandCore core) {
        return core == null ? 0 : core.getSpellSlots();
    }

    @Override
    public List<SpellPackage> getSpells(ItemStack stack) {
        ArrayList<SpellPackage> retVal = new ArrayList<SpellPackage>();
        if (stack != null) {
            ListTag spellTagsList = stack.m_41783_().m_128437_("Spells", 10);
            for (int index = 0; index < spellTagsList.size(); ++index) {
                CompoundTag spellTag = spellTagsList.m_128728_(index);
                SpellPackage newSpell = new SpellPackage(spellTag);
                if (newSpell == null) continue;
                retVal.add(newSpell);
            }
        }
        return retVal;
    }

    @Override
    public int getSpellCount(ItemStack stack) {
        if (stack != null) {
            return stack.m_41783_().m_128437_("Spells", 10).size();
        }
        return 0;
    }

    @Override
    public Component getSpellCapacityText(ItemStack stack) {
        if (stack == null) {
            return Component.m_237110_((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{0});
        }
        WandCore core = this.getWandCore(stack);
        if (core == null) {
            return Component.m_237110_((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{0});
        }
        int baseSlots = this.getCoreSpellSlotCount(core);
        Source bonusSlot = core.getBonusSlot();
        if (bonusSlot == null) {
            return Component.m_237110_((String)"tooltip.primalmagick.spells.capacity", (Object[])new Object[]{baseSlots});
        }
        MutableComponent bonusText = Component.m_237115_((String)bonusSlot.getNameTranslationKey());
        return Component.m_237110_((String)"tooltip.primalmagick.spells.capacity_with_bonus", (Object[])new Object[]{baseSlots, bonusText});
    }

    @Override
    public int getActiveSpellIndex(ItemStack stack) {
        return stack != null && stack.m_41783_().m_128441_("ActiveSpell") ? stack.m_41783_().m_128451_("ActiveSpell") : -1;
    }

    @Override
    public SpellPackage getActiveSpell(ItemStack stack) {
        SpellPackage retVal = null;
        if (stack != null) {
            ListTag spellTagsList = stack.m_41783_().m_128437_("Spells", 10);
            int index = this.getActiveSpellIndex(stack);
            if (index >= 0 && index < spellTagsList.size()) {
                CompoundTag spellTag = spellTagsList.m_128728_(index);
                retVal = new SpellPackage(spellTag);
            }
        }
        return retVal;
    }

    @Override
    public boolean setActiveSpellIndex(ItemStack stack, int index) {
        if (stack == null) {
            return false;
        }
        if (index >= -1 && index < this.getSpells(stack).size()) {
            stack.m_41700_("ActiveSpell", (Tag)IntTag.m_128679_((int)index));
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddSpell(ItemStack stack, SpellPackage spell) {
        if (stack == null || spell == null || spell.getPayload() == null) {
            return false;
        }
        WandCore core = this.getWandCore(stack);
        if (core == null) {
            return false;
        }
        List spellSources = this.getSpells(stack).stream().filter(p -> p != null && p.getPayload() != null).map(p -> p.getPayload().getSource()).collect(Collectors.toCollection(() -> new ArrayList()));
        spellSources.add(spell.getPayload().getSource());
        int coreSlots = this.getCoreSpellSlotCount(core);
        if (spellSources.size() < coreSlots + 1) {
            return true;
        }
        if (spellSources.size() > coreSlots + 1) {
            return false;
        }
        return core.getBonusSlot() != null && spellSources.contains(core.getBonusSlot());
    }

    @Override
    public boolean addSpell(ItemStack stack, SpellPackage spell) {
        if (this.canAddSpell(stack, spell)) {
            if (!stack.m_41783_().m_128441_("Spells")) {
                ListTag newList = new ListTag();
                newList.add((Object)spell.serializeNBT());
                stack.m_41700_("Spells", (Tag)newList);
                return true;
            }
            return stack.m_41783_().m_128437_("Spells", 10).add((Object)spell.serializeNBT());
        }
        return false;
    }

    @Override
    public void clearSpells(ItemStack stack) {
        stack.m_41783_().m_128473_("Spells");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final BlockEntityWithoutLevelRenderer renderer = new ModularWandISTER();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }
}

