/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.items.wands;

import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SpellScrollItem
extends Item {
    protected static final Component TOOLTIP = Component.m_237115_((String)"tooltip.primalmagick.spell_scroll").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});

    public SpellScrollItem() {
        super(new Item.Properties());
    }

    @Nullable
    public SpellPackage getSpell(@Nonnull ItemStack stack) {
        SpellPackage spell = null;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Spell")) {
            spell = new SpellPackage(stack.m_41783_().m_128469_("Spell"));
        }
        return spell;
    }

    public void setSpell(@Nonnull ItemStack stack, @Nonnull SpellPackage spell) {
        stack.m_41700_("Spell", (Tag)spell.serializeNBT());
    }

    public Component m_7626_(ItemStack stack) {
        SpellPackage spell = this.getSpell(stack);
        MutableComponent spellName = spell == null ? Component.m_237115_((String)"tooltip.primalmagick.none") : spell.getName();
        return Component.m_237110_((String)this.m_5671_(stack), (Object[])new Object[]{spellName}).m_130940_(ChatFormatting.ITALIC);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.addAll(SpellManager.getSpellPackageDetailTooltip(this.getSpell(stack), stack, false));
        tooltip.add(TOOLTIP);
    }

    public Rarity m_41460_(ItemStack stack) {
        SpellPackage spell = this.getSpell(stack);
        if (spell == null) {
            return Rarity.COMMON;
        }
        return spell.getRarity();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        if (!worldIn.f_46443_) {
            SpellPackage spell = this.getSpell(stack);
            if (spell != null && !SpellManager.isOnCooldown(playerIn)) {
                SpellManager.setCooldown(playerIn, spell.getCooldownTicks());
                spell.cast(worldIn, (LivingEntity)playerIn, stack);
                stack.m_41774_(1);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        super.m_7836_(stack, worldIn, playerIn);
        SpellPackage spell = this.getSpell(stack);
        if (spell != null) {
            StatsManager.incrementValue(playerIn, StatsPM.SPELLS_CRAFTED, stack.m_41613_());
            StatsManager.setValueIfMax(playerIn, StatsPM.SPELLS_CRAFTED_MAX_COST, spell.getManaCost().getManaSize());
        }
    }
}

