/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class BonusNuggetModifier
extends LootModifier {
    public static final Codec<BonusNuggetModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.unboundedMap((Codec)TagKey.m_203877_((ResourceKey)Registries.f_256747_), (Codec)TagKey.m_203877_((ResourceKey)Registries.f_256913_)).fieldOf("nuggetMap").forGetter(m -> m.nuggetMap), (App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance)))).apply((Applicative)inst, BonusNuggetModifier::new));
    protected final float chance;
    protected final Map<TagKey<Block>, TagKey<Item>> nuggetMap;

    public BonusNuggetModifier(LootItemCondition[] conditions, Map<TagKey<Block>, TagKey<Item>> nuggetMap, float chance) {
        super(conditions);
        this.nuggetMap = nuggetMap;
        this.chance = chance;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int enchantmentLevel;
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        int n = enchantmentLevel = tool == null ? 0 : tool.getEnchantmentLevel((Enchantment)EnchantmentsPM.LUCKY_STRIKE.get());
        if (state != null && enchantmentLevel > 0) {
            this.nuggetMap.forEach((blockTag, itemTag) -> {
                if (state.m_204336_(blockTag) && ForgeRegistries.ITEMS.tags().isKnownTagName(itemTag)) {
                    Optional<Item> nuggetOpt = ForgeRegistries.ITEMS.tags().getTag(itemTag).stream().findFirst();
                    nuggetOpt.ifPresent(nugget -> {
                        int nuggetCount = IntStream.range(0, enchantmentLevel).map(i -> context.m_230907_().m_188501_() < this.chance ? 1 : 0).sum();
                        generatedLoot.add((Object)new ItemStack((ItemLike)nugget, nuggetCount));
                    });
                }
            });
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

