/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class BountyFarmingModifier
extends LootModifier {
    public static final Codec<BountyFarmingModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, BountyFarmingModifier::new));
    protected final float chance;

    public BountyFarmingModifier(LootItemCondition[] conditionsIn, float chance) {
        super(conditionsIn);
        this.chance = chance;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LootTable table = context.m_78952_().m_7654_().m_278653_().m_278676_(((BlockState)context.m_78953_(LootContextParams.f_81461_)).m_60734_().m_60589_());
        int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentsPM.BOUNTY.get()), (ItemStack)((ItemStack)context.m_78953_(LootContextParams.f_81463_)));
        for (int index = 0; index < enchantmentLevel; ++index) {
            if (!(context.m_230907_().m_188501_() < this.chance)) continue;
            ArrayList<ItemStack> bonusList = new ArrayList<ItemStack>();
            table.m_79131_(context, bonusList::add);
            generatedLoot = (ObjectArrayList)ItemUtils.mergeItemStackLists(generatedLoot, bonusList).stream().collect(ObjectArrayList.toList());
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

