/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class EssenceThiefModifier
extends LootModifier {
    public static final Codec<EssenceThiefModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, EssenceThiefModifier::new));

    public EssenceThiefModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object = context.m_78953_(LootContextParams.f_81455_);
        if (object instanceof LivingEntity) {
            SourceList affinities;
            LivingEntity victim = (LivingEntity)object;
            int enchantLevel = EssenceThiefModifier.getEnchantLevel(context);
            if (enchantLevel > 0 && (affinities = AffinityManager.getInstance().getAffinityValuesAsync(victim.m_6095_(), victim.m_9236_().m_9598_()).join()) != null && !affinities.isEmpty()) {
                WeightedRandomBag<Source> bag = new WeightedRandomBag<Source>();
                for (Source source : affinities.getSources()) {
                    int amount = affinities.getAmount(source);
                    if (amount <= 0) continue;
                    bag.add(source, amount);
                }
                for (int index = 0; index < 2 * enchantLevel; ++index) {
                    generatedLoot.add((Object)EssenceItem.getEssence(EssenceType.DUST, (Source)bag.getRandom(context.m_230907_())));
                }
            }
        }
        return generatedLoot;
    }

    private static int getEnchantLevel(LootContext context) {
        Object object = context.m_78953_(LootContextParams.f_81458_);
        if (object instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)object;
            return ((Enchantment)EnchantmentsPM.ESSENCE_THIEF.get()).m_44684_(killer).values().stream().mapToInt(EssenceThiefModifier::getEnchantLevel).max().orElse(0);
        }
        return 0;
    }

    private static int getEnchantLevel(ItemStack stack) {
        return stack.getEnchantmentLevel((Enchantment)EnchantmentsPM.ESSENCE_THIEF.get());
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

