/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GuillotineModifier
extends LootModifier {
    public static final Codec<GuillotineModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, GuillotineModifier::new));
    protected final Item item;
    protected final float chance;

    public GuillotineModifier(LootItemCondition[] conditionsIn, Item item, float chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object = context.m_78953_(LootContextParams.f_81455_);
        if (object instanceof LivingEntity) {
            int enchantLevel;
            LivingEntity victim = (LivingEntity)object;
            if (generatedLoot.stream().allMatch(stack -> !stack.m_150930_(this.item)) && (enchantLevel = GuillotineModifier.getEnchantLevel(context)) > 0 && context.m_230907_().m_188501_() < this.chance * (float)enchantLevel) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        return generatedLoot;
    }

    private static int getEnchantLevel(LootContext context) {
        Object object = context.m_78953_(LootContextParams.f_81458_);
        if (object instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)object;
            return ((Enchantment)EnchantmentsPM.GUILLOTINE.get()).m_44684_(killer).values().stream().mapToInt(GuillotineModifier::getEnchantLevel).max().orElse(0);
        }
        return 0;
    }

    private static int getEnchantLevel(ItemStack stack) {
        return stack.getEnchantmentLevel((Enchantment)EnchantmentsPM.GUILLOTINE.get());
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

