/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class RelicFragmentsModifier
extends LootModifier {
    public static final Codec<RelicFragmentsModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.INT.fieldOf("minCount").forGetter(m -> m.minCount), (App)Codec.INT.fieldOf("maxCount").forGetter(m -> m.maxCount), (App)Codec.INT.fieldOf("lootingBonus").forGetter(m -> m.lootingBonus))).apply((Applicative)inst, RelicFragmentsModifier::new));
    protected final int minCount;
    protected final int maxCount;
    protected final int lootingBonus;

    public RelicFragmentsModifier(LootItemCondition[] conditionsIn, int minCount, int maxCount, int lootingBonus) {
        super(conditionsIn);
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.lootingBonus = lootingBonus;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        int lootingLevel = context.getLootingModifier();
        int count = context.m_230907_().m_188503_(this.maxCount - this.minCount + 1 + this.lootingBonus * lootingLevel) + this.minCount;
        if (count > 0) {
            generatedLoot.add((Object)new ItemStack((ItemLike)ItemsPM.MYSTICAL_RELIC_FRAGMENT.get(), count));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

