/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.items.misc.RuneItem;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.menus.slots.RunescribingResultSlot;
import com.verdantartifice.primalmagick.common.runes.Rune;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.tiles.crafting.RunescribingAltarTileEntity;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public abstract class AbstractRunescribingAltarMenu
extends AbstractTileMenu<RunescribingAltarTileEntity> {
    public static final ResourceLocation RUNE_SLOT_TEXTURE = PrimalMagick.resource("item/empty_rune_slot");
    protected final CraftingContainer altarInv = new TransientCraftingContainer(this, 4, 3){

        public int m_6893_() {
            return 1;
        }
    };
    protected final Container resultInv = new SimpleContainer(1);
    protected final Player player;
    protected final Level world;
    protected final Slot runeSlot;

    public AbstractRunescribingAltarMenu(@Nonnull MenuType<?> type, int id, @Nonnull Inventory playerInv, BlockPos tilePos, RunescribingAltarTileEntity altar) {
        super(type, id, RunescribingAltarTileEntity.class, playerInv.f_35978_.m_9236_(), tilePos, altar);
        int i;
        this.player = playerInv.f_35978_;
        this.world = this.player.m_9236_();
        this.m_38897_(new RunescribingResultSlot(this.player, (Container)this.altarInv, this.resultInv, 0, 138, 35));
        this.m_38897_(new Slot((Container)this.altarInv, 0, 19, 35));
        this.runeSlot = this.addRuneSlots();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInv, i, 8 + i * 18, 142));
        }
    }

    protected abstract int getRuneCapacity();

    @Nonnull
    protected abstract Slot addRuneSlots();

    protected static Slot makeRuneSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
        return new FilteredSlot(InventoryUtils.wrapInventory(inventoryIn, null), index, xPosition, yPosition, new FilteredSlot.Properties().background(RUNE_SLOT_TEXTURE).typeOf((Class<?>)RuneItem.class));
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, (Container)this.altarInv);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(slotStack, this.getRuneCapacity() + 2, this.getRuneCapacity() + 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index >= this.getRuneCapacity() + 2 && index < this.getRuneCapacity() + 38 ? (this.runeSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 2, this.getRuneCapacity() + 2, false) : !this.m_38903_(slotStack, 1, 2, false)) : !this.m_38903_(slotStack, this.getRuneCapacity() + 2, this.getRuneCapacity() + 38, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return stack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.resultInv && super.m_5882_(stack, slotIn);
    }

    public void m_6199_(Container inventoryIn) {
        super.m_6199_(inventoryIn);
        this.slotChangedCraftingGrid();
    }

    protected void slotChangedCraftingGrid() {
        if (!this.world.f_46443_ && this.player instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.f_41583_;
            ItemStack baseStack = this.altarInv.m_8020_(0);
            if (!RuneManager.hasRunes(baseStack)) {
                ArrayList<Rune> runes = new ArrayList<Rune>();
                for (int index = 1; index < this.altarInv.m_6643_(); ++index) {
                    ItemStack inputStack = this.altarInv.m_8020_(index);
                    if (inputStack == null || !(inputStack.m_41720_() instanceof RuneItem)) continue;
                    runes.add(((RuneItem)inputStack.m_41720_()).getRune());
                }
                Map<Enchantment, Integer> inputEnch = RuneManager.getRuneEnchantments(runes, baseStack, this.player, true);
                if (!inputEnch.isEmpty()) {
                    Map<Enchantment, Integer> finalEnch = RuneManager.mergeEnchantments(EnchantmentHelper.m_44831_((ItemStack)baseStack), inputEnch);
                    stack = baseStack.m_41777_();
                    EnchantmentHelper.m_44865_(finalEnch, (ItemStack)stack);
                    RuneManager.setRunes(stack, runes);
                }
            }
            this.resultInv.m_6836_(0, stack);
            spe.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, stack));
        }
    }
}

