/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.crafting.WandInventory;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import com.verdantartifice.primalmagick.common.menus.slots.ArcaneCraftingResultSlot;
import com.verdantartifice.primalmagick.common.menus.slots.WandSlot;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ArcaneWorkbenchMenu
extends AbstractContainerMenu
implements IArcaneRecipeBookMenu<CraftingContainer> {
    protected final CraftingContainer craftingInv = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    protected final WandInventory wandInv = new WandInventory(this);
    protected final ResultContainer resultInv = new ResultContainer();
    protected final ContainerLevelAccess worldPosCallable;
    protected final Player player;
    protected final Slot wandSlot;
    protected IArcaneRecipe activeArcaneRecipe = null;

    public ArcaneWorkbenchMenu(int windowId, Inventory inv) {
        this(windowId, inv, ContainerLevelAccess.f_39287_);
    }

    public ArcaneWorkbenchMenu(int windowId, Inventory inv, ContainerLevelAccess callable) {
        super((MenuType)MenuTypesPM.ARCANE_WORKBENCH.get(), windowId);
        int j;
        int i;
        this.worldPosCallable = callable;
        this.player = inv.f_35978_;
        this.m_38897_(new ArcaneCraftingResultSlot(this.player, this.craftingInv, this.wandInv, (Container)this.resultInv, 0, 138, 52));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftingInv, j + i * 3, 44 + j * 18, 34 + i * 18));
            }
        }
        this.wandSlot = this.m_38897_((Slot)new WandSlot(InventoryUtils.wrapInventory(this.wandInv, null), 0, 19, 52, false));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 101 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 159));
        }
    }

    @Nullable
    public IArcaneRecipe getActiveArcaneRecipe() {
        return this.activeArcaneRecipe;
    }

    public boolean m_6875_(Player playerIn) {
        return ArcaneWorkbenchMenu.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)((Block)BlocksPM.ARCANE_WORKBENCH.get()));
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.wandInv);
        this.m_150411_(playerIn, (Container)this.craftingInv);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(slotStack, 11, 47, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index >= 11 && index < 38 ? (this.wandSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 10, 11, false) : !this.m_38903_(slotStack, 1, 10, false) && !this.m_38903_(slotStack, 38, 47, false)) : (index >= 38 && index < 47 ? (this.wandSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 10, 11, false) : !this.m_38903_(slotStack, 1, 10, false) && !this.m_38903_(slotStack, 11, 38, false)) : !this.m_38903_(slotStack, 11, 47, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return stack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.resultInv && super.m_5882_(stack, slotIn);
    }

    public void m_6199_(Container inventoryIn) {
        super.m_6199_(inventoryIn);
        this.slotChangedCraftingGrid(this.player.m_9236_());
    }

    protected void slotChangedCraftingGrid(Level world) {
        if (world.f_46443_) {
            IArcaneRecipe recipe;
            this.activeArcaneRecipe = null;
            Optional arcaneOptional = world.m_7465_().m_44015_((RecipeType)RecipeTypesPM.ARCANE_CRAFTING.get(), (Container)this.craftingInv, world);
            if (arcaneOptional.isPresent() && ((recipe = (IArcaneRecipe)arcaneOptional.get()).getRequiredResearch() == null || recipe.getRequiredResearch().isKnownByStrict(this.player))) {
                this.activeArcaneRecipe = recipe;
            }
        }
        if (!world.f_46443_ && this.player instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.f_41583_;
            Optional arcaneOptional = world.m_7654_().m_129894_().m_44015_((RecipeType)RecipeTypesPM.ARCANE_CRAFTING.get(), (Container)this.craftingInv, world);
            if (arcaneOptional.isPresent()) {
                IArcaneRecipe recipe = (IArcaneRecipe)arcaneOptional.get();
                if (this.canUseArcaneRecipe(world, spe, recipe)) {
                    stack = recipe.m_5874_((Container)this.craftingInv, world.m_9598_());
                }
            } else {
                CraftingRecipe recipe;
                Optional vanillaOptional = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.craftingInv, world);
                if (vanillaOptional.isPresent() && this.resultInv.m_40135_(world, spe, (Recipe)(recipe = (CraftingRecipe)vanillaOptional.get()))) {
                    stack = recipe.m_5874_((Container)this.craftingInv, world.m_9598_());
                }
            }
            this.resultInv.m_6836_(0, stack);
            spe.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, stack));
        }
    }

    protected boolean canUseArcaneRecipe(Level world, ServerPlayer player, IArcaneRecipe recipe) {
        return !(!this.resultInv.m_40135_(world, player, (Recipe)recipe) || recipe.getRequiredResearch() != null && !recipe.getRequiredResearch().isKnownByStrict((Player)player) || !recipe.getManaCosts().isEmpty() && !this.wandContainsEnoughMana((Player)player, recipe));
    }

    protected boolean wandContainsEnoughMana(Player player, IArcaneRecipe recipe) {
        ItemStack stack = this.getWand();
        if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof IWand)) {
            return false;
        }
        IWand wand = (IWand)stack.m_41720_();
        return wand.containsRealMana(stack, player, recipe.getManaCosts());
    }

    @Override
    public void fillCraftSlotsStackedContents(StackedContents contents) {
        this.craftingInv.m_5809_(contents);
    }

    @Override
    public void clearCraftingContent() {
        this.craftingInv.m_6211_();
        this.resultInv.m_6211_();
    }

    @Override
    public boolean recipeMatches(Recipe<? super CraftingContainer> recipe) {
        return recipe.m_5818_((Container)this.craftingInv, this.player.m_9236_());
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return this.craftingInv.m_39347_();
    }

    @Override
    public int getGridHeight() {
        return this.craftingInv.m_39346_();
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public ArcaneRecipeBookType getRecipeBookType() {
        return ArcaneRecipeBookType.CRAFTING;
    }

    @Override
    public boolean shouldMoveToInventory(int index) {
        return index != this.getResultSlotIndex();
    }

    @Override
    public NonNullList<Slot> getSlots() {
        return this.f_38839_;
    }

    public ItemStack getWand() {
        return this.wandInv.m_8020_(0);
    }

    public Player getPlayer() {
        return this.player;
    }
}

