/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.devices.EssenceCaskTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EssenceCaskMenu
extends AbstractTileSidedInventoryMenu<EssenceCaskTileEntity> {
    protected final ContainerData caskData;
    protected final Slot inputSlot;

    public EssenceCaskMenu(int id, Inventory playerInv, BlockPos pos) {
        this(id, playerInv, pos, null, (ContainerData)new SimpleContainerData(EssenceCaskTileEntity.NUM_SLOTS));
    }

    public EssenceCaskMenu(int id, Inventory playerInv, BlockPos pos, EssenceCaskTileEntity cask, ContainerData caskData) {
        super((MenuType)MenuTypesPM.ESSENCE_CASK.get(), id, EssenceCaskTileEntity.class, playerInv.f_35978_.m_9236_(), pos, cask);
        EssenceCaskMenu.m_38886_((ContainerData)caskData, (int)EssenceCaskTileEntity.NUM_SLOTS);
        this.caskData = caskData;
        ((EssenceCaskTileEntity)this.tile).startOpen(playerInv.f_35978_);
        this.inputSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 0, 80, 108, new FilteredSlot.Properties().tag(ItemTagsPM.ESSENCES)));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 198));
        }
        this.m_38884_(this.caskData);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0 ? !this.m_38903_(slotStack, 1, 37, false) : (this.inputSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (index >= 1 && index < 28 ? !this.m_38903_(slotStack, 28, 37, false) : index >= 28 && index < 37 && !this.m_38903_(slotStack, 1, 28, false)))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
            this.m_38946_();
        }
        return stack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ((EssenceCaskTileEntity)this.tile).stopOpen(player);
    }

    public int getEssenceCount(int index) {
        return this.caskData.m_6413_(index);
    }

    public int getTotalEssenceCount() {
        int retVal = 0;
        for (int index = 0; index < this.caskData.m_6499_(); ++index) {
            retVal += this.caskData.m_6413_(index);
        }
        return retVal;
    }

    public int getTotalEssenceCapacity() {
        BlockEntity tile = this.level.m_7702_(this.tilePos);
        if (tile instanceof EssenceCaskTileEntity) {
            EssenceCaskTileEntity caskTile = (EssenceCaskTileEntity)tile;
            return caskTile.getTotalEssenceCapacity();
        }
        return 0;
    }

    public boolean isEssenceTypeVisible(EssenceType type, Player player) {
        if (type == null) {
            return false;
        }
        if (type.isDiscovered(player)) {
            return true;
        }
        int typeIndex = type.ordinal();
        int rowSize = Source.SORTED_SOURCES.size();
        for (int index = 0; index < this.caskData.m_6499_(); ++index) {
            if (index / rowSize != typeIndex || this.caskData.m_6413_(index) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isEssenceSourceVisible(Source source, Player player) {
        if (source == null) {
            return false;
        }
        if (source.isDiscovered(player)) {
            return true;
        }
        int sourceIndex = Source.SORTED_SOURCES.indexOf(source);
        int rowSize = Source.SORTED_SOURCES.size();
        for (int index = 0; index < this.caskData.m_6499_(); ++index) {
            if (index % rowSize != sourceIndex || this.caskData.m_6413_(index) <= 0) continue;
            return true;
        }
        return false;
    }
}

