/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.menus.slots.GenericResultSlot;
import com.verdantartifice.primalmagick.common.menus.slots.WandSlot;
import com.verdantartifice.primalmagick.common.tiles.devices.HoneyExtractorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HoneyExtractorMenu
extends AbstractTileSidedInventoryMenu<HoneyExtractorTileEntity> {
    public static final ResourceLocation BOTTLE_SLOT_TEXTURE = PrimalMagick.resource("item/empty_bottle_slot");
    public static final ResourceLocation HONEYCOMB_SLOT_TEXTURE = PrimalMagick.resource("item/empty_honeycomb_slot");
    protected final ContainerData extractorData;
    protected final Slot honeycombSlot;
    protected final Slot bottleSlot;
    protected final Slot wandSlot;

    public HoneyExtractorMenu(int id, Inventory playerInv, BlockPos tilePos) {
        this(id, playerInv, tilePos, null, (ContainerData)new SimpleContainerData(4));
    }

    public HoneyExtractorMenu(int id, Inventory playerInv, BlockPos tilePos, HoneyExtractorTileEntity extractor, ContainerData extractorData) {
        super((MenuType)MenuTypesPM.HONEY_EXTRACTOR.get(), id, HoneyExtractorTileEntity.class, playerInv.f_35978_.m_9236_(), tilePos, extractor);
        HoneyExtractorMenu.m_38886_((ContainerData)extractorData, (int)4);
        this.extractorData = extractorData;
        this.honeycombSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 0, 30, 35, new FilteredSlot.Properties().background(HONEYCOMB_SLOT_TEXTURE).item(Items.f_42784_)));
        this.bottleSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 1, 52, 35, new FilteredSlot.Properties().background(BOTTLE_SLOT_TEXTURE).item(Items.f_42590_)));
        this.m_38897_((Slot)new GenericResultSlot(playerInv.f_35978_, this.getTileInventory(Direction.DOWN), 0, 108, 35));
        this.m_38897_((Slot)new GenericResultSlot(playerInv.f_35978_, this.getTileInventory(Direction.DOWN), 1, 130, 35));
        this.wandSlot = this.m_38897_((Slot)new WandSlot(this.getTileInventory(Direction.NORTH), 0, 8, 62, false));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        this.m_38884_(this.extractorData);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 2 || index == 3) {
                if (!this.m_38903_(slotStack, 5, 41, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index == 0 || index == 1 || index == 4 ? !this.m_38903_(slotStack, 5, 41, false) : (this.honeycombSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (this.bottleSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : (this.wandSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 4, 5, false) : (index >= 5 && index < 32 ? !this.m_38903_(slotStack, 32, 41, false) : index >= 32 && index < 41 && !this.m_38903_(slotStack, 5, 32, false)))))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
            this.m_38946_();
        }
        return stack;
    }

    public int getSpinProgressionScaled() {
        int i = this.extractorData.m_6413_(0);
        int j = this.extractorData.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getCurrentMana() {
        return this.extractorData.m_6413_(2);
    }

    public int getMaxMana() {
        return this.extractorData.m_6413_(3);
    }
}

