/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.menus.slots.InfernalFurnaceResultSlot;
import com.verdantartifice.primalmagick.common.menus.slots.WandSlot;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.devices.InfernalFurnaceTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class InfernalFurnaceMenu
extends AbstractTileSidedInventoryMenu<InfernalFurnaceTileEntity>
implements IArcaneRecipeBookMenu<Container> {
    public static final ResourceLocation IGNYX_SLOT_TEXTURE = PrimalMagick.resource("item/empty_ignyx_slot");
    protected final ContainerData furnaceData;
    protected final Slot inputSlot;
    protected final Slot ignyxSlot;
    protected final Slot wandSlot;

    public InfernalFurnaceMenu(int id, Inventory playerInv, BlockPos tilePos) {
        this(id, playerInv, tilePos, null, (ContainerData)new SimpleContainerData(6));
    }

    public InfernalFurnaceMenu(int id, Inventory playerInv, BlockPos tilePos, InfernalFurnaceTileEntity furnace, ContainerData furnaceData) {
        super((MenuType)MenuTypesPM.INFERNAL_FURNACE.get(), id, InfernalFurnaceTileEntity.class, playerInv.f_35978_.m_9236_(), tilePos, furnace);
        InfernalFurnaceMenu.m_38886_((ContainerData)furnaceData, (int)6);
        this.furnaceData = furnaceData;
        this.m_38897_((Slot)new InfernalFurnaceResultSlot(playerInv.f_35978_, this.getTileInventory(Direction.DOWN), 0, 125, 35));
        this.inputSlot = this.m_38897_((Slot)new SlotItemHandler(this.getTileInventory(Direction.UP), 0, 44, 17));
        this.ignyxSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.NORTH), 0, 44, 53, new FilteredSlot.Properties().background(IGNYX_SLOT_TEXTURE).tag(ItemTagsPM.INFERNAL_SUPERCHARGE_FUEL)));
        this.wandSlot = this.m_38897_((Slot)new WandSlot(this.getTileInventory(Direction.NORTH), 1, 8, 62, false));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
        this.m_38884_(this.furnaceData);
    }

    public int getProcessProgressionScaled() {
        int i = this.furnaceData.m_6413_(0);
        int j = this.furnaceData.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getCurrentMana() {
        return this.furnaceData.m_6413_(2);
    }

    public int getMaxMana() {
        return this.furnaceData.m_6413_(3);
    }

    public int getSuperchargeProgressionScaled() {
        int i = this.furnaceData.m_6413_(4);
        int j = this.furnaceData.m_6413_(5);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public boolean isSupercharged() {
        return this.furnaceData.m_6413_(4) > 0;
    }

    @Override
    public void fillCraftSlotsStackedContents(StackedContents contents) {
        ((InfernalFurnaceTileEntity)this.tile).m_5809_(contents);
    }

    @Override
    public void clearCraftingContent() {
        this.m_38853_(0).m_5852_(ItemStack.f_41583_);
        this.m_38853_(1).m_5852_(ItemStack.f_41583_);
    }

    @Override
    public boolean recipeMatches(Recipe<? super Container> recipe) {
        IItemHandler iItemHandler = this.getTileInventory(Direction.UP);
        if (iItemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
            return recipe.m_5818_((Container)new RecipeWrapper(modifiable), this.level);
        }
        return false;
    }

    @Override
    public int getResultSlotIndex() {
        return 0;
    }

    @Override
    public int getGridWidth() {
        return 1;
    }

    @Override
    public int getGridHeight() {
        return 1;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public ArcaneRecipeBookType getRecipeBookType() {
        return ArcaneRecipeBookType.FURNACE;
    }

    @Override
    public boolean shouldMoveToInventory(int index) {
        return true;
    }

    @Override
    public boolean isSingleIngredientMenu() {
        return true;
    }

    @Override
    public NonNullList<Slot> getSlots() {
        return this.f_38839_;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(slotStack, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index >= 4 && index < 31 ? (this.wandSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 3, 4, false) : (this.ignyxSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 2, 3, false) : !this.m_38903_(slotStack, 1, 2, false) && !this.m_38903_(slotStack, 31, 40, false))) : (index >= 31 && index < 40 ? (this.wandSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 3, 4, false) : (this.ignyxSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 2, 3, false) : !this.m_38903_(slotStack, 1, 2, false) && !this.m_38903_(slotStack, 4, 31, false))) : !this.m_38903_(slotStack, 4, 40, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
            this.m_38946_();
        }
        return stack;
    }
}

