/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.data.ContainerSynchronizerLarge;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tiles.mana.ManaBatteryTileEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ManaBatteryMenu
extends AbstractTileSidedInventoryMenu<ManaBatteryTileEntity> {
    protected final ContainerData data;
    protected final Slot inputSlot;
    protected final Slot chargeSlot;
    protected final Player player;

    public ManaBatteryMenu(int id, Inventory playerInv, BlockPos tilePos) {
        this(id, playerInv, tilePos, null, (ContainerData)new SimpleContainerData(20));
    }

    public ManaBatteryMenu(int id, Inventory playerInv, BlockPos tilePos, ManaBatteryTileEntity tile, ContainerData data) {
        super((MenuType)MenuTypesPM.MANA_BATTERY.get(), id, ManaBatteryTileEntity.class, playerInv.f_35978_.m_9236_(), tilePos, tile);
        ManaBatteryMenu.m_38886_((ContainerData)data, (int)20);
        this.player = playerInv.f_35978_;
        this.data = data;
        this.inputSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 0, 8, 34, new FilteredSlot.Properties().typeOf(EssenceItem.class, IWand.class)));
        this.chargeSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.NORTH), 0, 206, 34, new FilteredSlot.Properties().filter(stack -> stack.m_41720_() instanceof IWand || stack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).isPresent())));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 35 + j * 18, 82 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 35 + k * 18, 140));
        }
        this.m_38884_(this.data);
    }

    public void m_150416_(ContainerSynchronizer pSynchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            super.m_150416_((ContainerSynchronizer)new ContainerSynchronizerLarge(serverPlayer));
        } else {
            super.m_150416_(pSynchronizer);
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index >= 2 && index < 29 ? (this.chargeSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : (this.inputSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : !this.m_38903_(slotStack, 29, 38, false))) : (index >= 29 && index < 38 ? (this.chargeSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : (this.inputSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : !this.m_38903_(slotStack, 2, 29, false))) : !this.m_38903_(slotStack, 2, 38, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return stack;
    }

    public int getChargeProgressionScaled() {
        int i = this.data.m_6413_(0);
        int j = this.data.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getCurrentMana(Source source) {
        int sourceIndex = Source.SORTED_SOURCES.indexOf(source);
        return this.data.m_6413_(2 + 2 * sourceIndex);
    }

    public int getMaxMana(Source source) {
        int sourceIndex = Source.SORTED_SOURCES.indexOf(source);
        return this.data.m_6413_(3 + 2 * sourceIndex);
    }
}

