/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.theorycrafting.IWritingImplement;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import com.verdantartifice.primalmagick.common.tiles.devices.ResearchTableTileEntity;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ResearchTableMenu
extends AbstractTileSidedInventoryMenu<ResearchTableTileEntity>
implements ContainerListener {
    public static final ResourceLocation PAPER_SLOT_TEXTURE = PrimalMagick.resource("item/empty_paper_slot");
    public static final ResourceLocation PENCIL_SLOT_TEXTURE = PrimalMagick.resource("item/empty_pencil_slot");
    protected final Player player;
    protected final Slot paperSlot;
    protected final Slot pencilSlot;
    protected final DataSlot writingReady = DataSlot.m_39401_();

    public ResearchTableMenu(int windowId, Inventory inv, BlockPos pos) {
        this(windowId, inv, pos, null);
    }

    public ResearchTableMenu(int windowId, Inventory inv, BlockPos pos, ResearchTableTileEntity table) {
        super((MenuType)MenuTypesPM.RESEARCH_TABLE.get(), windowId, ResearchTableTileEntity.class, inv.f_35978_.m_9236_(), pos, table);
        int i;
        this.player = inv.f_35978_;
        this.pencilSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 0, 8, 8, new FilteredSlot.Properties().background(PENCIL_SLOT_TEXTURE).typeOf((Class<?>)IWritingImplement.class)));
        this.paperSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 1, 206, 8, new FilteredSlot.Properties().background(PAPER_SLOT_TEXTURE).item(Items.f_42516_)));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 35 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 35 + i * 18, 198));
        }
        this.m_38895_(this.writingReady).m_6422_(0);
        this.checkWritingImplements();
    }

    protected void checkWritingImplements() {
        boolean ready = !this.getWritingImplementStack().m_41619_() && !this.getPaperStack().m_41619_();
        this.writingReady.m_6422_(ready ? 1 : 0);
    }

    public void m_5757_(Container invBasic) {
        this.checkWritingImplements();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index >= 2 && index < 29 ? (this.pencilSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (this.paperSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : !this.m_38903_(slotStack, 29, 38, false))) : (index >= 29 && index < 38 ? (this.pencilSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (this.paperSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : !this.m_38903_(slotStack, 2, 29, false))) : !this.m_38903_(slotStack, 2, 38, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return stack;
    }

    @Nonnull
    protected ItemStack getWritingImplementStack() {
        return ((ResearchTableTileEntity)this.tile).getItem(0, 0);
    }

    @Nonnull
    protected ItemStack getPaperStack() {
        return ((ResearchTableTileEntity)this.tile).getItem(0, 1);
    }

    public boolean isWritingReady() {
        return this.writingReady.m_6501_() != 0;
    }

    public void consumeWritingImplements() {
        if (!this.player.m_150110_().f_35937_) {
            IWritingImplement inkItem;
            Item item;
            ItemStack inkStack = this.getWritingImplementStack();
            if (!inkStack.m_41619_() && (item = inkStack.m_41720_()) instanceof IWritingImplement && (inkItem = (IWritingImplement)item).isDamagedOnUse()) {
                inkStack.m_41622_(1, (LivingEntity)this.player, player -> {});
            }
            ((ResearchTableTileEntity)this.tile).getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(inv -> inv.extractItem(1, 1, false));
        }
    }

    @Nonnull
    public List<Component> getNearbyAidBlockNames() {
        Set nearby = (Set)this.containerLevelAccess.m_39299_((level, pos) -> TheorycraftManager.getNearbyAidBlocks(this.player.m_9236_(), pos), Collections.emptySet());
        return nearby.stream().map(b -> b.m_49954_()).distinct().sorted(Comparator.comparing(c -> c.getString())).collect(Collectors.toList());
    }
}

