/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileSidedInventoryMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.menus.slots.GenericResultSlot;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.crafting.RunecarvingTableTileEntity;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class RunecarvingTableMenu
extends AbstractTileSidedInventoryMenu<RunecarvingTableTileEntity>
implements ContainerListener {
    public static final ResourceLocation BASE_SLOT_TEXTURE = PrimalMagick.resource("item/empty_slab_slot");
    public static final ResourceLocation ETCHING_SLOT_TEXTURE = PrimalMagick.resource("item/empty_lapis_slot");
    protected final DataSlot selectedRecipe = DataSlot.m_39401_();
    protected final Player player;
    protected final Slot inputSlabSlot;
    protected final Slot inputLapisSlot;
    protected final Slot outputSlot;
    protected final ResultContainer outputInventory = new ResultContainer();
    protected final Optional<RecipeWrapper> tileInvWrapper;
    protected List<IRunecarvingRecipe> recipes = new ArrayList<IRunecarvingRecipe>();
    protected ItemStack slabInput = ItemStack.f_41583_;
    protected ItemStack lapisInput = ItemStack.f_41583_;
    protected long lastOnTake;
    protected Runnable inventoryUpdateListener = () -> {};

    public RunecarvingTableMenu(int windowId, Inventory inv, BlockPos pos) {
        this(windowId, inv, pos, null);
    }

    public RunecarvingTableMenu(int windowId, Inventory inv, BlockPos pos, RunecarvingTableTileEntity table) {
        super((MenuType)MenuTypesPM.RUNECARVING_TABLE.get(), windowId, RunecarvingTableTileEntity.class, inv.f_35978_.m_9236_(), pos, table);
        int i;
        Optional<Object> optional;
        this.player = inv.f_35978_;
        IItemHandler iItemHandler = this.getTileInventory(Direction.UP);
        if (iItemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
            optional = Optional.of(new RecipeWrapper(modifiable));
        } else {
            optional = Optional.empty();
        }
        this.tileInvWrapper = optional;
        ((RunecarvingTableTileEntity)this.tile).addListener(Direction.UP, this);
        this.inputSlabSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 0, 20, 21, new FilteredSlot.Properties().background(BASE_SLOT_TEXTURE).tag(ItemTagsPM.RUNE_BASES)));
        this.inputLapisSlot = this.m_38897_((Slot)new FilteredSlot(this.getTileInventory(Direction.UP), 1, 20, 46, new FilteredSlot.Properties().background(ETCHING_SLOT_TEXTURE).tag(ItemTagsPM.RUNE_ETCHINGS)));
        this.outputSlot = this.m_38897_((Slot)new GenericResultSlot(this.player, InventoryUtils.wrapInventory((Container)this.outputInventory, null), 0, 143, 33){

            @Override
            public void m_142406_(Player thePlayer, ItemStack stack) {
                RunecarvingTableMenu.this.getTileInventory(Direction.UP).extractItem(0, 1, false);
                RunecarvingTableMenu.this.getTileInventory(Direction.UP).extractItem(1, 1, false);
                RunecarvingTableMenu.this.updateRecipeResultSlot(thePlayer.m_9236_().m_9598_());
                stack.m_41720_().m_7836_(stack, thePlayer.m_9236_(), thePlayer);
                RunecarvingTableMenu.this.containerLevelAccess.m_39292_((world, pos) -> {
                    long time = world.m_46467_();
                    if (RunecarvingTableMenu.this.lastOnTake != time) {
                        world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        RunecarvingTableMenu.this.lastOnTake = time;
                    }
                });
                super.m_142406_(thePlayer, stack);
            }

            @Override
            protected void m_5845_(ItemStack stack) {
                super.m_5845_(stack);
                StatsManager.incrementValue(this.player, StatsPM.CRAFTED_RUNEWORKING, stack.m_41613_());
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
        this.m_38895_(this.selectedRecipe);
        if (this.tileInvWrapper.isPresent()) {
            this.m_5757_((Container)this.tileInvWrapper.get());
        }
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.m_6501_();
    }

    public List<IRunecarvingRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputSlabSlot.m_6657_() && this.inputLapisSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectedRecipe.m_6422_(id);
            this.updateRecipeResultSlot(playerIn.m_9236_().m_9598_());
        }
        return true;
    }

    public void m_5757_(Container inventoryIn) {
        ItemStack slabStack = this.inputSlabSlot.m_7993_();
        ItemStack lapisStack = this.inputLapisSlot.m_7993_();
        if (slabStack.m_41720_() != this.slabInput.m_41720_() || lapisStack.m_41720_() != this.lapisInput.m_41720_()) {
            this.slabInput = slabStack.m_41777_();
            this.lapisInput = lapisStack.m_41777_();
            this.updateAvailableRecipes(inventoryIn, slabStack, lapisStack);
        }
        this.inventoryUpdateListener.run();
    }

    protected void updateAvailableRecipes(Container inventoryIn, ItemStack slabStack, ItemStack lapisStack) {
        this.recipes.clear();
        this.selectedRecipe.m_6422_(-1);
        this.outputSlot.m_5852_(ItemStack.f_41583_);
        this.recipes = this.level.m_7465_().m_44056_((RecipeType)RecipeTypesPM.RUNECARVING.get(), inventoryIn, this.level).stream().filter(r -> r != null && (r.getRequiredResearch() == null || r.getRequiredResearch().isKnownByStrict(this.player))).collect(Collectors.toList());
    }

    protected void updateRecipeResultSlot(RegistryAccess registryAccess) {
        if (!this.recipes.isEmpty() && this.tileInvWrapper.isPresent()) {
            IRunecarvingRecipe recipe = this.recipes.get(this.selectedRecipe.m_6501_());
            this.outputSlot.m_5852_(recipe.m_5874_((Container)this.tileInvWrapper.get(), registryAccess));
        } else {
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.m_5882_(stack, slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 2) {
                slotStack.m_41720_().m_7836_(slotStack, playerIn.m_9236_(), playerIn);
                if (!this.m_38903_(slotStack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index == 0 || index == 1 ? !this.m_38903_(slotStack, 3, 39, false) : (this.inputSlabSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 0, 1, false) : (this.inputLapisSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : (index >= 3 && index < 30 ? !this.m_38903_(slotStack, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(slotStack, 3, 30, false))))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
            this.m_38946_();
        }
        return stack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.outputInventory.m_8016_(0);
    }
}

