/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.runes.RuneEnchantmentDefinition;
import com.verdantartifice.primalmagick.common.runes.RuneManager;
import com.verdantartifice.primalmagick.common.runes.RuneType;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class RunicGrindstoneMenu
extends AbstractContainerMenu {
    protected static final List<RuneType> RUNE_TYPES = List.of(RuneType.VERB, RuneType.NOUN, RuneType.SOURCE);
    protected static final Supplier<SimpleResearchKey> UNLOCK_INDEX_RESEARCH = ResearchNames.simpleKey(ResearchNames.UNLOCK_RUNE_ENCHANTMENTS);
    public final Container resultSlots = new ResultContainer();
    public final Container repairSlots = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            RunicGrindstoneMenu.this.m_6199_((Container)this);
        }
    };
    protected final ContainerLevelAccess worldPosCallable;
    protected Player player;
    private int xp = -1;

    public RunicGrindstoneMenu(int windowId, Inventory playerInv) {
        this(windowId, playerInv, ContainerLevelAccess.f_39287_);
    }

    public RunicGrindstoneMenu(int windowId, Inventory playerInv, final ContainerLevelAccess worldPosCallable) {
        super((MenuType)MenuTypesPM.RUNIC_GRINDSTONE.get(), windowId);
        this.worldPosCallable = worldPosCallable;
        this.player = playerInv.f_35978_;
        this.m_38897_(RunicGrindstoneMenu.makeInputSlot(this.repairSlots, 0, 49, 19));
        this.m_38897_(RunicGrindstoneMenu.makeInputSlot(this.repairSlots, 1, 49, 40));
        this.m_38897_(new Slot(this.resultSlots, 2, 129, 34){

            public boolean m_5857_(ItemStack pStack) {
                return false;
            }

            public void m_142406_(Player pPlayer, ItemStack pStack) {
                worldPosCallable.m_39292_((level, pos) -> {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)pos), (int)this.getExperienceAmount((Level)level));
                        ItemStack preWipeStack = RunicGrindstoneMenu.this.mergeEnchants(RunicGrindstoneMenu.this.repairSlots.m_8020_(0), RunicGrindstoneMenu.this.repairSlots.m_8020_(1));
                        RunicGrindstoneMenu.this.grantHints(preWipeStack);
                    }
                    level.m_46796_(1042, pos, 0);
                });
                RunicGrindstoneMenu.this.repairSlots.m_6836_(0, ItemStack.f_41583_);
                RunicGrindstoneMenu.this.repairSlots.m_6836_(1, ItemStack.f_41583_);
            }

            private int getExperienceAmount(Level level) {
                if (RunicGrindstoneMenu.this.xp > -1) {
                    return RunicGrindstoneMenu.this.xp;
                }
                int l = 0;
                l += this.getExperienceFromItem(RunicGrindstoneMenu.this.repairSlots.m_8020_(0));
                if ((l += this.getExperienceFromItem(RunicGrindstoneMenu.this.repairSlots.m_8020_(1))) > 0) {
                    int i1 = (int)Math.ceil((double)l / 2.0);
                    return i1 + level.f_46441_.m_188503_(i1);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack stack) {
                int total = 0;
                Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
                for (Map.Entry entry : map.entrySet()) {
                    if (((Enchantment)entry.getKey()).m_6589_()) continue;
                    total += ((Enchantment)entry.getKey()).m_6183_(((Integer)entry.getValue()).intValue());
                }
                return total;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
    }

    protected static Slot makeInputSlot(Container pContainer, int pSlot, int pX, int pY) {
        return new FilteredSlot(InventoryUtils.wrapInventory(pContainer, null), pSlot, pX, pY, new FilteredSlot.Properties().filter(stack -> stack.m_41763_() || stack.m_150930_(Items.f_42690_) || stack.m_41793_() || stack.canGrindstoneRepair() || RuneManager.hasRunes(stack)));
    }

    public void m_6199_(Container pContainer) {
        super.m_6199_(pContainer);
        if (pContainer == this.repairSlots) {
            this.createResult();
        }
    }

    public ItemStack removeNonCurses(ItemStack stack, int damage, int count) {
        ItemStack retVal = stack.m_255036_(count);
        retVal.m_41749_("Enchantments");
        retVal.m_41749_("StoredEnchantments");
        if (damage > 0) {
            retVal.m_41721_(damage);
        } else {
            retVal.m_41749_("Damage");
        }
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(map, (ItemStack)retVal);
        retVal.m_41742_(0);
        if (retVal.m_150930_(Items.f_42690_) && map.size() == 0) {
            retVal = new ItemStack((ItemLike)Items.f_42517_);
            if (stack.m_41788_()) {
                retVal.m_41714_(stack.m_41786_());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            retVal.m_41742_(AnvilMenu.m_39025_((int)retVal.m_41610_()));
        }
        RuneManager.clearRunes(retVal);
        return retVal;
    }

    public void createResult() {
        boolean flag1;
        ItemStack itemstack = this.repairSlots.m_8020_(0);
        ItemStack itemstack1 = this.repairSlots.m_8020_(1);
        boolean flag = !itemstack.m_41619_() || !itemstack1.m_41619_();
        boolean bl = flag1 = !itemstack.m_41619_() && !itemstack1.m_41619_();
        if (!flag) {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
        } else {
            ItemStack itemstack2;
            int i;
            boolean flag2;
            boolean bl2 = flag2 = !itemstack.m_41619_() && !itemstack.m_150930_(Items.f_42690_) && !itemstack.m_41793_() && !RuneManager.hasRunes(itemstack) || !itemstack1.m_41619_() && !itemstack1.m_150930_(Items.f_42690_) && !itemstack1.m_41793_() && !RuneManager.hasRunes(itemstack1);
            if (itemstack.m_41613_() > 1 || itemstack1.m_41613_() > 1 || !flag1 && flag2) {
                this.resultSlots.m_6836_(0, ItemStack.f_41583_);
                this.m_38946_();
                return;
            }
            int j = 1;
            if (flag1) {
                if (!itemstack.m_150930_(itemstack1.m_41720_())) {
                    this.resultSlots.m_6836_(0, ItemStack.f_41583_);
                    this.m_38946_();
                    return;
                }
                int k = itemstack.m_41776_() - itemstack.m_41773_();
                int l = itemstack.m_41776_() - itemstack1.m_41773_();
                int i1 = k + l + itemstack.m_41776_() * 5 / 100;
                i = Math.max(itemstack.m_41776_() - i1, 0);
                itemstack2 = this.mergeEnchants(itemstack, itemstack1);
                if (!itemstack2.isRepairable()) {
                    i = itemstack.m_41773_();
                }
                if (!itemstack2.m_41763_() || !itemstack2.isRepairable()) {
                    if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)itemstack1)) {
                        this.resultSlots.m_6836_(0, ItemStack.f_41583_);
                        this.m_38946_();
                        return;
                    }
                    j = 2;
                }
            } else {
                boolean flag3 = !itemstack.m_41619_();
                i = flag3 ? itemstack.m_41773_() : itemstack1.m_41773_();
                ItemStack itemStack = itemstack2 = flag3 ? itemstack : itemstack1;
            }
            if (j > itemstack2.m_41741_()) {
                this.resultSlots.m_6836_(0, ItemStack.f_41583_);
            } else {
                this.resultSlots.m_6836_(0, this.removeNonCurses(itemstack2, i, j));
            }
        }
        this.m_38946_();
        this.worldPosCallable.m_39292_((world, pos) -> {
            Player patt11016$temp;
            if (!world.f_46443_ && (patt11016$temp = this.player) instanceof ServerPlayer) {
                ServerPlayer spe = (ServerPlayer)patt11016$temp;
                ItemStack stack = this.resultSlots.m_8020_(0);
                spe.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 2, stack));
            }
        });
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.worldPosCallable.m_39292_((level, pos) -> this.m_150411_(pPlayer, this.repairSlots));
    }

    public boolean m_6875_(Player playerIn) {
        return RunicGrindstoneMenu.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)playerIn, (Block)((Block)BlocksPM.RUNIC_GRINDSTONE.get()));
    }

    protected void grantHints(ItemStack stack) {
        Set enchants = EnchantmentHelper.m_44831_((ItemStack)stack).keySet();
        int hintCount = 0;
        for (Enchantment enchant : enchants) {
            List<SimpleResearchKey> candidates;
            RuneEnchantmentDefinition definition;
            CompoundResearchKey requirements;
            SimpleResearchKey fullResearch = SimpleResearchKey.parseRuneEnchantment(enchant);
            if (!RuneManager.hasRuneDefinition(enchant) || fullResearch.isKnownByStrict(this.player) || (requirements = (definition = RuneManager.getRuneDefinition(enchant)).getRequiredResearch()) != null && !requirements.isKnownByStrict(this.player) || (candidates = definition.getRunes().stream().filter(rune -> rune.getDiscoveryKey().isKnownByStrict(this.player)).map(rune -> SimpleResearchKey.parsePartialRuneEnchantment(enchant, rune.getType())).filter(key -> !key.isKnownByStrict(this.player)).toList()).isEmpty()) continue;
            WeightedRandomBag<SimpleResearchKey> candidateBag = new WeightedRandomBag<SimpleResearchKey>();
            for (SimpleResearchKey candidate : candidates) {
                candidateBag.add(candidate, 1.0);
            }
            ResearchManager.completeResearch(this.player, UNLOCK_INDEX_RESEARCH.get());
            ResearchManager.completeResearch(this.player, (SimpleResearchKey)candidateBag.getRandom(this.player.m_217043_()));
            ++hintCount;
            if (!definition.getRunes().stream().map(rune -> SimpleResearchKey.parsePartialRuneEnchantment(enchant, rune.getType())).allMatch(key -> key.isKnownByStrict(this.player))) continue;
            ResearchManager.completeResearch(this.player, fullResearch);
        }
        if (hintCount > 0) {
            this.player.m_5661_((Component)Component.m_237115_((String)"event.primalmagick.runic_grindstone.hints_granted").m_130940_(ChatFormatting.GREEN), false);
        }
    }

    public ItemStack mergeEnchants(ItemStack pCopyTo, ItemStack pCopyFrom) {
        ItemStack itemstack = pCopyTo.m_41777_();
        Map map = EnchantmentHelper.m_44831_((ItemStack)pCopyFrom);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (enchantment.m_6589_() && EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)itemstack) != 0) continue;
            itemstack.m_41663_(enchantment, ((Integer)entry.getValue()).intValue());
        }
        return itemstack;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            ItemStack itemstack2 = this.repairSlots.m_8020_(0);
            ItemStack itemstack3 = this.repairSlots.m_8020_(1);
            if (pIndex == 2) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex != 0 && pIndex != 1 ? (!itemstack2.m_41619_() && !itemstack3.m_41619_() ? (pIndex >= 3 && pIndex < 30 ? !this.m_38903_(itemstack1, 30, 39, false) : pIndex >= 30 && pIndex < 39 && !this.m_38903_(itemstack1, 3, 30, false)) : !this.m_38903_(itemstack1, 0, 2, false)) : !this.m_38903_(itemstack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }
}

