/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.crafting.SpellcraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.WandInventory;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.wands.SpellScrollItem;
import com.verdantartifice.primalmagick.common.menus.MenuTypesPM;
import com.verdantartifice.primalmagick.common.menus.base.AbstractTileMenu;
import com.verdantartifice.primalmagick.common.menus.slots.FilteredSlot;
import com.verdantartifice.primalmagick.common.menus.slots.SpellcraftingResultSlot;
import com.verdantartifice.primalmagick.common.menus.slots.WandSlot;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.SpellComponent;
import com.verdantartifice.primalmagick.common.spells.SpellFactory;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.ISpellMod;
import com.verdantartifice.primalmagick.common.spells.payloads.ISpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.ISpellVehicle;
import com.verdantartifice.primalmagick.common.tiles.crafting.SpellcraftingAltarTileEntity;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SpellcraftingAltarMenu
extends AbstractTileMenu<SpellcraftingAltarTileEntity> {
    protected static final ResourceLocation RECIPE_LOC = PrimalMagick.resource("spellcrafting");
    protected final CraftingContainer scrollInv = new TransientCraftingContainer((AbstractContainerMenu)this, 1, 1);
    protected final WandInventory wandInv = new WandInventory(this);
    protected final ResultContainer resultInv = new ResultContainer();
    protected final Player player;
    protected final Slot wandSlot;
    protected final Slot scrollSlot;
    protected String spellName = "";
    protected int spellVehicleTypeIndex = 0;
    protected int spellPayloadTypeIndex = 0;
    protected int spellPrimaryModTypeIndex = 0;
    protected int spellSecondaryModTypeIndex = 0;
    protected SpellPackage spellPackageCache = null;
    protected Map<SpellComponent, Map<String, Integer>> spellPropertyCache = new HashMap<SpellComponent, Map<String, Integer>>();

    public SpellcraftingAltarMenu(int windowId, Inventory inv, BlockPos tilePos) {
        this(windowId, inv, tilePos, null);
    }

    public SpellcraftingAltarMenu(int windowId, Inventory inv, BlockPos tilePos, SpellcraftingAltarTileEntity altar) {
        super((MenuType)MenuTypesPM.SPELLCRAFTING_ALTAR.get(), windowId, SpellcraftingAltarTileEntity.class, inv.f_35978_.m_9236_(), tilePos, altar);
        int i;
        this.player = inv.f_35978_;
        for (SpellComponent comp : SpellComponent.values()) {
            this.spellPropertyCache.put(comp, new HashMap());
        }
        this.m_38897_((Slot)new SpellcraftingResultSlot(this.player, this.scrollInv, this.wandInv, this::getManaCosts, (Container)this.resultInv, 0, 206, 8));
        this.wandSlot = this.m_38897_((Slot)new WandSlot(InventoryUtils.wrapInventory(this.wandInv, null), 0, 8, 8, false));
        this.scrollSlot = this.m_38897_((Slot)new FilteredSlot(InventoryUtils.wrapInventory((Container)this.scrollInv, null), 0, 160, 8, new FilteredSlot.Properties().item((Item)ItemsPM.SPELL_SCROLL_BLANK.get())));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 35 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 35 + i * 18, 198));
        }
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return SpellcraftingAltarMenu.m_38889_((ContainerLevelAccess)this.containerLevelAccess, (Player)playerIn, (Block)((Block)BlocksPM.SPELLCRAFTING_ALTAR.get()));
    }

    public SourceList getManaCosts() {
        return this.getSpellPackage().getManaCost();
    }

    public Player getPlayer() {
        return this.player;
    }

    public SpellPackage getSpellPackage() {
        if (this.spellPackageCache == null) {
            this.spellPackageCache = this.makeFinalSpellPackage();
        }
        return this.spellPackageCache;
    }

    protected SpellPackage makeFinalSpellPackage() {
        SpellPackage spell = new SpellPackage();
        spell.setName(this.getSpellName());
        spell.setVehicle(this.getSpellVehicleComponent());
        spell.setPayload(this.getSpellPayloadComponent());
        spell.setPrimaryMod(this.getSpellPrimaryModComponent());
        spell.setSecondaryMod(this.getSpellSecondaryModComponent());
        return spell;
    }

    public String getSpellName() {
        return this.spellName == null || this.spellName.isEmpty() ? this.getDefaultSpellName().getString() : this.spellName;
    }

    @Nonnull
    public Component getDefaultSpellName() {
        Component vehiclePiece = this.getSpellVehicleComponent().getDefaultNamePiece();
        Component payloadPiece = this.getSpellPayloadComponent().getDefaultNamePiece();
        Component primaryModPiece = this.getSpellPrimaryModComponent().getDefaultNamePiece();
        Component secondaryModPiece = this.getSpellSecondaryModComponent().getDefaultNamePiece();
        boolean primaryActive = this.getSpellPrimaryModComponent().isActive();
        boolean secondaryActive = this.getSpellSecondaryModComponent().isActive();
        if (vehiclePiece == null || payloadPiece == null || vehiclePiece.getString().isEmpty() || payloadPiece.getString().isEmpty()) {
            return Component.m_237113_((String)"");
        }
        if (!primaryActive && !secondaryActive) {
            return Component.m_237110_((String)"spells.primalmagick.default_name_format.mods.0", (Object[])new Object[]{vehiclePiece, payloadPiece});
        }
        if (primaryActive && secondaryActive) {
            return Component.m_237110_((String)"spells.primalmagick.default_name_format.mods.2", (Object[])new Object[]{vehiclePiece, payloadPiece, primaryModPiece, secondaryModPiece});
        }
        if (primaryActive) {
            return Component.m_237110_((String)"spells.primalmagick.default_name_format.mods.1", (Object[])new Object[]{vehiclePiece, payloadPiece, primaryModPiece});
        }
        return Component.m_237110_((String)"spells.primalmagick.default_name_format.mods.1", (Object[])new Object[]{vehiclePiece, payloadPiece, secondaryModPiece});
    }

    public void setSpellName(String name) {
        this.spellName = name;
        this.spellPackageCache = null;
        this.containerLevelAccess.m_39292_((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected ISpellVehicle getSpellVehicleComponent() {
        ISpellVehicle retVal = SpellFactory.getVehicleFromType(SpellManager.getVehicleTypes(this.player).get(this.getSpellVehicleTypeIndex()));
        if (retVal != null) {
            for (Map.Entry<String, Integer> entry : this.spellPropertyCache.get((Object)SpellComponent.VEHICLE).entrySet()) {
                if (retVal.getProperty(entry.getKey()) == null) continue;
                retVal.getProperty(entry.getKey()).setValue(entry.getValue());
            }
        }
        return retVal;
    }

    public int getSpellVehicleTypeIndex() {
        return this.spellVehicleTypeIndex;
    }

    public void setSpellVehicleTypeIndex(int index) {
        this.spellVehicleTypeIndex = index = Mth.m_14045_((int)index, (int)0, (int)(SpellManager.getVehicleTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.m_39292_((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected ISpellPayload getSpellPayloadComponent() {
        ISpellPayload retVal = SpellFactory.getPayloadFromType(SpellManager.getPayloadTypes(this.player).get(this.getSpellPayloadTypeIndex()));
        if (retVal != null) {
            for (Map.Entry<String, Integer> entry : this.spellPropertyCache.get((Object)SpellComponent.PAYLOAD).entrySet()) {
                if (retVal.getProperty(entry.getKey()) == null) continue;
                retVal.getProperty(entry.getKey()).setValue(entry.getValue());
            }
        }
        return retVal;
    }

    public int getSpellPayloadTypeIndex() {
        return this.spellPayloadTypeIndex;
    }

    public void setSpellPayloadTypeIndex(int index) {
        this.spellPayloadTypeIndex = index = Mth.m_14045_((int)index, (int)0, (int)(SpellManager.getPayloadTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.m_39292_((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected ISpellMod getSpellPrimaryModComponent() {
        ISpellMod retVal = SpellFactory.getModFromType(SpellManager.getModTypes(this.player).get(this.getSpellPrimaryModTypeIndex()));
        if (retVal != null) {
            for (Map.Entry<String, Integer> entry : this.spellPropertyCache.get((Object)SpellComponent.PRIMARY_MOD).entrySet()) {
                if (retVal.getProperty(entry.getKey()) == null) continue;
                retVal.getProperty(entry.getKey()).setValue(entry.getValue());
            }
        }
        return retVal;
    }

    public int getSpellPrimaryModTypeIndex() {
        return this.spellPrimaryModTypeIndex;
    }

    public void setSpellPrimaryModTypeIndex(int index) {
        this.spellPrimaryModTypeIndex = index = Mth.m_14045_((int)index, (int)0, (int)(SpellManager.getModTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.m_39292_((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected ISpellMod getSpellSecondaryModComponent() {
        ISpellMod retVal = SpellFactory.getModFromType(SpellManager.getModTypes(this.player).get(this.getSpellSecondaryModTypeIndex()));
        if (retVal != null) {
            for (Map.Entry<String, Integer> entry : this.spellPropertyCache.get((Object)SpellComponent.SECONDARY_MOD).entrySet()) {
                if (retVal.getProperty(entry.getKey()) == null) continue;
                retVal.getProperty(entry.getKey()).setValue(entry.getValue());
            }
        }
        return retVal;
    }

    public int getSpellSecondaryModTypeIndex() {
        return this.spellSecondaryModTypeIndex;
    }

    public void setSpellSecondaryModTypeIndex(int index) {
        this.spellSecondaryModTypeIndex = index = Mth.m_14045_((int)index, (int)0, (int)(SpellManager.getModTypes(this.player).size() - 1));
        this.spellPackageCache = null;
        this.containerLevelAccess.m_39292_((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    public void setSpellPropertyValue(SpellComponent component, String name, int value) {
        SpellPackage spell = this.getSpellPackage();
        SpellProperty property = null;
        if (component == SpellComponent.VEHICLE && spell.getVehicle() != null) {
            property = spell.getVehicle().getProperty(name);
        } else if (component == SpellComponent.PAYLOAD && spell.getPayload() != null) {
            property = spell.getPayload().getProperty(name);
        } else if (component == SpellComponent.PRIMARY_MOD && spell.getPrimaryMod() != null) {
            property = spell.getPrimaryMod().getProperty(name);
        } else if (component == SpellComponent.SECONDARY_MOD && spell.getSecondaryMod() != null) {
            property = spell.getSecondaryMod().getProperty(name);
        }
        if (property != null) {
            property.setValue(value);
            this.spellPropertyCache.get((Object)component).put(name, value);
            this.containerLevelAccess.m_39292_((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
        }
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.wandInv);
        this.m_150411_(playerIn, (Container)this.scrollInv);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(slotStack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (index >= 3 && index < 30 ? (this.wandSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : (this.scrollSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 2, 3, false) : !this.m_38903_(slotStack, 30, 39, false))) : (index >= 30 && index < 39 ? (this.wandSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 1, 2, false) : (this.scrollSlot.m_5857_(slotStack) ? !this.m_38903_(slotStack, 2, 3, false) : !this.m_38903_(slotStack, 3, 30, false))) : !this.m_38903_(slotStack, 3, 39, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return stack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.resultInv && super.m_5882_(stack, slotIn);
    }

    public void m_6199_(Container inventoryIn) {
        super.m_6199_(inventoryIn);
        this.containerLevelAccess.m_39292_((world, blockPos) -> this.slotChangedCraftingGrid((Level)world));
    }

    protected void slotChangedCraftingGrid(Level world) {
        if (!world.f_46443_ && this.player instanceof ServerPlayer) {
            SpellcraftingRecipe recipe;
            ServerPlayer spe = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.f_41583_;
            Optional opt = world.m_7654_().m_129894_().m_44043_(RECIPE_LOC);
            if (opt.isPresent() && opt.get() instanceof SpellcraftingRecipe && (recipe = (SpellcraftingRecipe)((Object)opt.get())).matches(this.scrollInv, world) && this.wandContainsEnoughMana((Player)spe) && this.getSpellPackage().isValid() && (stack = recipe.assemble(this.scrollInv, world.m_9598_())) != null && stack.m_41720_() instanceof SpellScrollItem) {
                ((SpellScrollItem)stack.m_41720_()).setSpell(stack, this.getSpellPackage());
            }
            this.resultInv.m_6836_(0, stack);
            spe.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 0, stack));
        }
    }

    protected boolean wandContainsEnoughMana(Player player) {
        ItemStack stack = this.wandInv.m_8020_(0);
        if (stack == null || stack.m_41619_() || !(stack.m_41720_() instanceof IWand)) {
            return false;
        }
        IWand wand = (IWand)stack.m_41720_();
        return wand.containsRealMana(stack, player, this.getManaCosts());
    }

    public ItemStack getWand() {
        return this.wandInv.m_8020_(0);
    }
}

