/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus.slots;

import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.crafting.WandInventory;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class ArcaneCraftingResultSlot
extends Slot {
    protected final CraftingContainer craftingInventory;
    protected final WandInventory wandInventory;
    protected final Player player;
    protected int amountCrafted;

    public ArcaneCraftingResultSlot(Player player, CraftingContainer craftingInventory, WandInventory wandInventory, Container inventoryIn, int slotIndex, int xPosition, int yPosition) {
        super(inventoryIn, slotIndex, xPosition, yPosition);
        this.craftingInventory = craftingInventory;
        this.wandInventory = wandInventory;
        this.player = player;
    }

    public boolean m_5857_(ItemStack stack) {
        return false;
    }

    public ItemStack m_6201_(int amount) {
        if (this.m_6657_()) {
            this.amountCrafted += Math.min(amount, this.m_7993_().m_41613_());
        }
        return super.m_6201_(amount);
    }

    protected void m_7169_(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.m_5845_(stack);
    }

    protected void m_6405_(int amount) {
        this.amountCrafted += amount;
    }

    protected void m_5845_(ItemStack stack) {
        Container container;
        RecipeHolder recipeHolder;
        if (this.amountCrafted > 0) {
            stack.m_41678_(this.player.m_9236_(), this.player, this.amountCrafted);
            ForgeEventFactory.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.craftingInventory);
            Container container2 = this.f_40218_;
            if (container2 instanceof RecipeHolder && (container2 = (recipeHolder = (RecipeHolder)container2).m_7928_()) instanceof IArcaneRecipe) {
                IArcaneRecipe arcaneRecipe = (IArcaneRecipe)container2;
                CompoundResearchKey key = arcaneRecipe.getRequiredResearch();
                List<ResearchEntry> entryList = ResearchEntries.getEntries(key);
                HashSet<String> recordedDisciplines = new HashSet<String>();
                for (ResearchEntry entry : entryList) {
                    String discKey;
                    ResearchDiscipline disc;
                    if (entry == null || (disc = ResearchDisciplines.getDiscipline(entry.getDisciplineKey())) == null || recordedDisciplines.contains(discKey = disc.getKey())) continue;
                    recordedDisciplines.add(discKey);
                    Stat craftingStat = disc.getCraftingStat();
                    if (craftingStat == null) continue;
                    StatsManager.incrementValue(this.player, craftingStat, this.amountCrafted);
                }
            }
        }
        if ((container = this.f_40218_) instanceof RecipeHolder) {
            recipeHolder = (RecipeHolder)container;
            recipeHolder.m_58395_(this.player, this.craftingInventory.m_280657_());
        }
        this.amountCrafted = 0;
    }

    public void m_142406_(Player thePlayer, ItemStack stack) {
        NonNullList remainingList;
        Item item;
        ItemStack wandStack;
        IArcaneRecipe arcaneRecipe;
        SourceList manaCosts;
        Recipe recipe;
        RecipeHolder holder;
        this.m_5845_(stack);
        Container container = this.f_40218_;
        if (container instanceof RecipeHolder && (holder = (RecipeHolder)container).m_7928_() != null && (recipe = holder.m_7928_()) instanceof IArcaneRecipe && !(manaCosts = (arcaneRecipe = (IArcaneRecipe)recipe).getManaCosts()).isEmpty() && (wandStack = this.wandInventory.m_8020_(0)) != null && !wandStack.m_41619_() && (item = wandStack.m_41720_()) instanceof IWand) {
            IWand wand = (IWand)item;
            wand.consumeRealMana(wandStack, this.player, manaCosts);
        }
        ForgeHooks.setCraftingPlayer((Player)thePlayer);
        Level level = thePlayer.m_9236_();
        Optional arcaneOptional = level.m_7465_().m_44015_((RecipeType)RecipeTypesPM.ARCANE_CRAFTING.get(), (Container)this.craftingInventory, level);
        if (arcaneOptional.isPresent()) {
            remainingList = ((IArcaneRecipe)arcaneOptional.get()).m_7457_((Container)this.craftingInventory);
        } else {
            Optional vanillaOptional = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftingInventory, level);
            if (vanillaOptional.isPresent()) {
                remainingList = ((CraftingRecipe)vanillaOptional.get()).m_7457_((Container)this.craftingInventory);
            } else {
                remainingList = NonNullList.m_122780_((int)this.craftingInventory.m_6643_(), (Object)ItemStack.f_41583_);
                for (int index = 0; index < remainingList.size(); ++index) {
                    remainingList.set(index, (Object)this.craftingInventory.m_8020_(index));
                }
            }
        }
        ForgeHooks.setCraftingPlayer(null);
        for (int index = 0; index < remainingList.size(); ++index) {
            ItemStack materialStack = this.craftingInventory.m_8020_(index);
            ItemStack remainingStack = (ItemStack)remainingList.get(index);
            if (!materialStack.m_41619_()) {
                this.craftingInventory.m_7407_(index, 1);
                materialStack = this.craftingInventory.m_8020_(index);
            }
            if (remainingStack.m_41619_()) continue;
            if (materialStack.m_41619_()) {
                this.craftingInventory.m_6836_(index, remainingStack);
                continue;
            }
            if (ItemStack.m_150942_((ItemStack)materialStack, (ItemStack)remainingStack)) {
                remainingStack.m_41769_(materialStack.m_41613_());
                this.craftingInventory.m_6836_(index, remainingStack);
                continue;
            }
            if (this.player.m_150109_().m_36054_(remainingStack)) continue;
            this.player.m_36176_(remainingStack, false);
        }
    }
}

