/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.menus.slots;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FilteredSlot
extends SlotItemHandler {
    private final Optional<Predicate<ItemStack>> filter;
    private final OptionalInt maxStackSize;

    public FilteredSlot(IItemHandler pItemHandler, int pSlot, int pX, int pY, Properties properties) {
        super(pItemHandler, pSlot, pX, pY);
        this.filter = properties.filter;
        this.maxStackSize = properties.maxStackSize;
        properties.background.ifPresent(bg -> this.setBackground(InventoryMenu.f_39692_, (ResourceLocation)bg));
    }

    public boolean m_5857_(ItemStack pStack) {
        return this.filter.orElse(x$0 -> super.m_5857_(x$0)).test(pStack);
    }

    public int m_6641_() {
        return this.maxStackSize.orElseGet(() -> super.m_6641_());
    }

    public static class Properties {
        private Optional<Predicate<ItemStack>> filter = Optional.empty();
        private Optional<ResourceLocation> background = Optional.empty();
        private OptionalInt maxStackSize = OptionalInt.empty();

        public Properties filter(Predicate<ItemStack> filter) {
            this.filter = Optional.ofNullable(filter);
            return this;
        }

        public Properties item(Item item) {
            Objects.requireNonNull(item);
            return this.filter(stack -> stack.m_150930_(item));
        }

        public Properties item(Item ... items) {
            Objects.requireNonNull(items);
            return this.filter(stack -> Stream.of(items).anyMatch(item -> stack.m_150930_(item)));
        }

        public Properties tag(TagKey<Item> tagKey) {
            Objects.requireNonNull(tagKey);
            return this.filter(stack -> stack.m_204117_(tagKey));
        }

        public Properties typeOf(Class<?> clazz) {
            Objects.requireNonNull(clazz);
            return this.filter(stack -> clazz.isInstance(stack.m_41720_()));
        }

        public Properties typeOf(Class<?> ... clazzes) {
            Objects.requireNonNull(clazzes);
            return this.filter(stack -> Stream.of(clazzes).anyMatch(clazz -> clazz.isInstance(stack.m_41720_())));
        }

        public Properties background(ResourceLocation loc) {
            this.background = Optional.ofNullable(loc);
            return this;
        }

        public Properties stacksTo(int size) {
            this.maxStackSize = OptionalInt.of(size);
            return this;
        }
    }
}

