/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.misc;

import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;

public class BlockBreaker {
    protected static final Map<ResourceLocation, ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>>> SCHEDULE = new ConcurrentHashMap<ResourceLocation, ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>>>();
    protected final float power;
    protected final BlockPos pos;
    protected final BlockState targetBlock;
    protected final float currentDurability;
    protected final float maxDurability;
    protected final Player player;
    protected final ItemStack tool;
    protected final boolean oneShot;
    protected final boolean skipEvent;
    protected final boolean alwaysDrop;
    protected final Optional<Boolean> silkTouchOverride;
    protected final Optional<Integer> fortuneOverride;

    protected BlockBreaker(float power, @Nonnull BlockPos pos, @Nonnull BlockState targetBlock, float currentDurability, float maxDurability, @Nonnull Player player, ItemStack tool, boolean oneShot, boolean skipEvent, boolean alwaysDrop, Optional<Boolean> silkTouchOverride, Optional<Integer> fortuneOverride) {
        this.power = power;
        this.pos = pos;
        this.targetBlock = targetBlock;
        this.currentDurability = currentDurability;
        this.maxDurability = maxDurability;
        this.player = player;
        this.tool = tool;
        this.oneShot = oneShot;
        this.skipEvent = skipEvent;
        this.alwaysDrop = alwaysDrop;
        this.silkTouchOverride = silkTouchOverride;
        this.fortuneOverride = fortuneOverride;
    }

    public static boolean schedule(@Nonnull Level world, int delayTicks, @Nullable BlockBreaker breaker) {
        if (breaker == null) {
            return false;
        }
        int delay = Math.max(0, delayTicks);
        SCHEDULE.computeIfAbsent(world.m_46472_().m_135782_(), key -> new ConcurrentSkipListMap()).computeIfAbsent(delay, key -> new ConcurrentHashMap()).put(breaker.pos, breaker);
        return true;
    }

    public static Iterable<BlockBreaker> tick(@Nonnull Level world) {
        ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>> tree = SCHEDULE.get(world.m_46472_().m_135782_());
        if (tree == null) {
            return Collections.emptyList();
        }
        Collection<BlockBreaker> retVal = Collections.emptyList();
        ConcurrentSkipListMap<Integer, Map> newTree = new ConcurrentSkipListMap<Integer, Map>();
        while (!tree.isEmpty()) {
            Map.Entry entry = tree.pollFirstEntry();
            if ((Integer)entry.getKey() <= 0) {
                retVal = ((Map)entry.getValue()).values();
                continue;
            }
            newTree.put((Integer)entry.getKey() - 1, (Map)entry.getValue());
        }
        if (!newTree.isEmpty()) {
            SCHEDULE.put(world.m_46472_().m_135782_(), newTree);
        }
        return retVal;
    }

    public static boolean hasBreakerQueued(@Nonnull Level world, @Nonnull BlockPos pos) {
        ConcurrentNavigableMap<Integer, Map<BlockPos, BlockBreaker>> tree = SCHEDULE.get(world.m_46472_().m_135782_());
        if (tree != null) {
            for (Map tickMap : tree.values()) {
                if (!tickMap.keySet().contains(pos)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public BlockBreaker execute(@Nonnull Level world) {
        BlockBreaker retVal = null;
        BlockState state = world.m_8055_(this.pos);
        if (state == this.targetBlock && world.m_7966_(this.player, this.pos) && state.m_60800_((BlockGetter)world, this.pos) >= 0.0f) {
            world.m_6801_(this.pos.hashCode(), this.pos, (int)((1.0f - this.currentDurability / this.maxDurability) * 10.0f));
            float newDurability = this.currentDurability - this.power;
            if (newDurability <= 0.0f) {
                this.doHarvest(world);
                world.m_6801_(this.pos.hashCode(), this.pos, -1);
            } else if (!this.oneShot) {
                retVal = new Builder(this).currentDurability(newDurability).build();
            }
        }
        return retVal;
    }

    protected boolean doHarvest(@Nonnull Level world) {
        int exp;
        if (world.f_46443_ || !(this.player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)this.player;
        ServerLevel serverWorld = (ServerLevel)world;
        int n = exp = this.skipEvent ? 0 : ForgeHooks.onBlockBreakEvent((Level)world, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)serverPlayer, (BlockPos)this.pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        BlockState state = world.m_8055_(this.pos);
        Block block = state.m_60734_();
        if (exp == 0 && !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)this.player)) {
            exp = state.getExpDrop((LevelReader)world, world.f_46441_, this.pos, this.getFortuneLevel(), this.getSilkTouchLevel());
        }
        if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !serverPlayer.m_36337_()) {
            world.m_7260_(this.pos, state, state, 3);
            return false;
        }
        if (serverPlayer.m_21205_().onBlockStartBreak(this.pos, (Player)serverPlayer)) {
            return false;
        }
        if (serverPlayer.m_36187_(world, this.pos, serverPlayer.f_8941_.m_9290_())) {
            return false;
        }
        world.m_5898_(null, 2001, this.pos, Block.m_49956_((BlockState)state));
        if (serverPlayer.f_8941_.m_9295_()) {
            this.removeBlock(world, false);
            return true;
        }
        boolean canHarvest = this.alwaysDrop || state.canHarvestBlock((BlockGetter)world, this.pos, (Player)serverPlayer);
        boolean success = this.removeBlock(world, canHarvest);
        if (success && canHarvest) {
            block.m_6240_(world, (Player)serverPlayer, this.pos, state, tile, this.getHarvestTool((Player)serverPlayer));
        }
        if (success && exp > 0) {
            block.m_49805_(serverWorld, this.pos, exp);
        }
        return true;
    }

    protected int getFortuneLevel() {
        if (this.fortuneOverride.isPresent()) {
            return this.fortuneOverride.get();
        }
        if (!this.tool.m_41619_()) {
            if (this.tool.m_41720_() instanceof IWand) {
                return this.tool.getEnchantmentLevel((Enchantment)EnchantmentsPM.TREASURE.get());
            }
            return this.tool.getEnchantmentLevel(Enchantments.f_44987_);
        }
        return 0;
    }

    protected int getSilkTouchLevel() {
        if (this.silkTouchOverride.isPresent()) {
            return this.silkTouchOverride.get() != false ? 1 : 0;
        }
        if (!this.tool.m_41619_()) {
            return this.tool.getEnchantmentLevel(Enchantments.f_44985_);
        }
        return 0;
    }

    protected ItemStack getHarvestTool(Player player) {
        ItemStack stack = this.tool.m_41777_();
        if (stack.m_41619_()) {
            stack = player.m_21205_().m_41777_();
        }
        if (this.silkTouchOverride.isPresent() || this.fortuneOverride.isPresent()) {
            Map enchantMap = EnchantmentHelper.m_44831_((ItemStack)stack);
            this.silkTouchOverride.ifPresent(silk -> {
                if (silk.booleanValue()) {
                    enchantMap.put(Enchantments.f_44985_, 1);
                }
            });
            this.fortuneOverride.ifPresent(fortune -> {
                int newFortune = Math.max(fortune, enchantMap.getOrDefault(Enchantments.f_44987_, 0));
                if (newFortune > 0) {
                    enchantMap.put(Enchantments.f_44987_, newFortune);
                }
            });
            EnchantmentHelper.m_44865_((Map)enchantMap, (ItemStack)stack);
        }
        return stack;
    }

    protected boolean removeBlock(@Nonnull Level world, boolean canHarvest) {
        BlockState state = world.m_8055_(this.pos);
        boolean removed = state.onDestroyedByPlayer(world, this.pos, this.player, canHarvest, world.m_6425_(this.pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)world, this.pos, state);
        }
        return removed;
    }

    public static class Builder {
        protected float power = 0.0f;
        protected BlockPos pos = BlockPos.f_121853_;
        protected BlockState targetBlock = null;
        protected float currentDurability = 0.0f;
        protected float maxDurability = 0.0f;
        protected Player player = null;
        protected ItemStack tool = ItemStack.f_41583_;
        protected boolean oneShot = false;
        protected boolean skipEvent = false;
        protected boolean alwaysDrop = false;
        protected Optional<Boolean> silkTouchOverride = Optional.empty();
        protected Optional<Integer> fortuneOverride = Optional.empty();

        public Builder() {
        }

        public Builder(BlockBreaker existing) {
            this.power = existing.power;
            this.pos = existing.pos;
            this.targetBlock = existing.targetBlock;
            this.currentDurability = existing.currentDurability;
            this.maxDurability = existing.maxDurability;
            this.player = existing.player;
            this.tool = existing.tool;
            this.oneShot = existing.oneShot;
            this.skipEvent = existing.skipEvent;
            this.alwaysDrop = existing.alwaysDrop;
            this.silkTouchOverride = existing.silkTouchOverride;
            this.fortuneOverride = existing.fortuneOverride;
        }

        public Builder power(float power) {
            this.power = power;
            return this;
        }

        public Builder target(BlockPos pos, BlockState targetBlock) {
            this.pos = pos;
            this.targetBlock = targetBlock;
            return this;
        }

        public Builder durability(float max) {
            return this.durability(max, max);
        }

        public Builder durability(float current, float max) {
            this.currentDurability = current;
            this.maxDurability = max;
            return this;
        }

        public Builder currentDurability(float current) {
            this.currentDurability = current;
            return this;
        }

        public Builder player(Player player) {
            this.player = player;
            return this;
        }

        public Builder tool(ItemStack tool) {
            this.tool = tool;
            return this;
        }

        public Builder oneShot() {
            this.oneShot = true;
            return this;
        }

        public Builder skipEvent() {
            this.skipEvent = true;
            return this;
        }

        public Builder alwaysDrop() {
            this.alwaysDrop = true;
            return this;
        }

        public Builder silkTouch(boolean silk) {
            this.silkTouchOverride = Optional.of(silk);
            return this;
        }

        public Builder fortune(int fortune) {
            this.fortuneOverride = Optional.of(fortune);
            return this;
        }

        private void validate() {
            if (this.targetBlock == null) {
                throw new IllegalStateException("Missing target block in BlockBreaker builder!");
            }
            if (this.player == null) {
                throw new IllegalStateException("Missing player in BlockBreaker builder!");
            }
            if (this.tool == null) {
                throw new IllegalStateException("Invalid tool in BlockBreaker builder!");
            }
        }

        public BlockBreaker build() {
            this.validate();
            return new BlockBreaker(this.power, this.pos, this.targetBlock, this.currentDurability, this.maxDurability, this.player, this.tool, this.oneShot, this.skipEvent, this.alwaysDrop, this.silkTouchOverride, this.fortuneOverride);
        }
    }
}

