/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.misc;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.WandPoofPacket;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockSwapper {
    protected static final Map<ResourceLocation, Queue<BlockSwapper>> REGISTRY = new HashMap<ResourceLocation, Queue<BlockSwapper>>();
    protected final BlockPos pos;
    protected final BlockState source;
    protected final ItemStack target;
    protected final Player player;

    public BlockSwapper(@Nonnull BlockPos pos, @Nullable BlockState source, @Nullable ItemStack target, @Nonnull Player player) {
        this.pos = pos;
        this.source = source;
        this.target = target;
        this.player = player;
    }

    public static boolean enqueue(@Nonnull Level world, @Nullable BlockSwapper swapper) {
        if (swapper == null) {
            return false;
        }
        return BlockSwapper.getWorldSwappers(world).offer(swapper);
    }

    @Nonnull
    public static Queue<BlockSwapper> getWorldSwappers(@Nonnull Level world) {
        return REGISTRY.computeIfAbsent(world.m_46472_().m_135782_(), key -> new LinkedBlockingQueue());
    }

    public void execute(Level world) {
        boolean allow;
        BlockState state = world.m_8055_(this.pos);
        boolean bl = allow = state.m_60800_((BlockGetter)world, this.pos) >= 0.0f && (this.source == null || this.source.equals(state));
        if (allow && world.m_7966_(this.player, this.pos) && this.isTargetDifferent(state) && this.canPlace(world, state)) {
            if (this.target == null || this.target.m_41619_()) {
                world.m_7471_(this.pos, false);
            } else {
                Block targetBlock = Block.m_49814_((Item)this.target.m_41720_());
                if (targetBlock != null && targetBlock != Blocks.f_50016_) {
                    BlockState targetState = targetBlock.m_49966_();
                    if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                        targetState = (BlockState)targetState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
                    } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                        targetState = (BlockState)targetState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
                    }
                    world.m_7731_(this.pos, targetState, 3);
                    BlockEntity tile = world.m_7702_(this.pos);
                    if (tile instanceof IOwnedTileEntity) {
                        ((IOwnedTileEntity)tile).setTileOwner(this.player);
                    }
                } else {
                    world.m_7471_(this.pos, false);
                    ItemEntity entity = new ItemEntity(world, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_(), (double)this.pos.m_123343_() + 0.5, this.target.m_41777_());
                    entity.m_20334_(0.0, 0.0, 0.0);
                    world.m_7967_((Entity)entity);
                }
                PacketHandler.sendToAllAround(new WandPoofPacket(this.pos, Color.WHITE.getRGB(), true, Direction.UP), (ResourceKey<Level>)world.m_46472_(), this.pos, 32.0);
            }
        }
    }

    protected boolean isTargetDifferent(BlockState sourceState) {
        return this.target == null || this.target.m_41619_() || !ItemStack.m_41656_((ItemStack)this.target, (ItemStack)new ItemStack((ItemLike)sourceState.m_60734_()));
    }

    protected boolean canPlace(Level world, BlockState state) {
        return !ForgeEventFactory.onBlockPlace((Entity)this.player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)this.pos), (Direction)Direction.UP);
    }
}

