/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.misc;

import com.verdantartifice.primalmagick.common.capabilities.IWorldEntitySwappers;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.WandPoofPacket;
import java.awt.Color;
import java.util.Collection;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class EntitySwapper
implements INBTSerializable<CompoundTag> {
    protected UUID targetId = null;
    protected EntityType<?> entityType = null;
    protected CompoundTag originalData = null;
    protected Optional<Integer> polymorphDuration = Optional.empty();
    protected int delay = 0;

    protected EntitySwapper() {
    }

    public EntitySwapper(@Nonnull UUID targetId, @Nonnull EntityType<?> entityType, @Nullable CompoundTag originalData, @Nonnull Optional<Integer> polymorphDuration, int delay) {
        this.targetId = targetId;
        this.entityType = entityType;
        this.originalData = originalData;
        this.polymorphDuration = polymorphDuration;
        this.delay = delay;
    }

    public EntitySwapper(CompoundTag tag) {
        this();
        this.deserializeNBT(tag);
    }

    public static boolean enqueue(@Nonnull Level world, @Nullable EntitySwapper swapper) {
        if (swapper == null) {
            return false;
        }
        IWorldEntitySwappers swappers = PrimalMagickCapabilities.getEntitySwappers(world);
        if (swappers == null) {
            return false;
        }
        return swappers.enqueue(swapper);
    }

    @Nullable
    public static Queue<EntitySwapper> getWorldSwappers(@Nonnull Level world) {
        IWorldEntitySwappers swappers = PrimalMagickCapabilities.getEntitySwappers(world);
        if (swappers == null) {
            return null;
        }
        return swappers.getQueue();
    }

    public static boolean setWorldSwapperQueue(@Nonnull Level world, @Nonnull Queue<EntitySwapper> swapperQueue) {
        IWorldEntitySwappers swappers = PrimalMagickCapabilities.getEntitySwappers(world);
        if (swappers == null) {
            return false;
        }
        return swappers.setQueue(swapperQueue);
    }

    @Nullable
    public EntitySwapper execute(@Nonnull Level world) {
        if (!world.f_46443_ && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            Entity target = serverWorld.m_8791_(this.targetId);
            if (this.isValid() && target != null && this.isValidTarget(target)) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (livingTarget.m_20159_()) {
                    livingTarget.m_8127_();
                }
                if (livingTarget.m_20160_()) {
                    livingTarget.m_20153_();
                }
                EntityType oldType = livingTarget.m_6095_();
                Vec3 targetPos = livingTarget.m_20182_();
                Vec2 targetRots = livingTarget.m_20155_();
                Component customName = livingTarget.m_7770_();
                boolean customNameVisible = livingTarget.m_20151_();
                double healthPercentage = (double)livingTarget.m_21223_() / (double)livingTarget.m_21233_();
                Collection activeEffects = livingTarget.m_21220_();
                CompoundTag data = null;
                if (this.originalData != null) {
                    data = new CompoundTag();
                    data.m_128365_("EntityTag", (Tag)this.pruneData(this.originalData, this.polymorphDuration.isPresent()));
                }
                PacketHandler.sendToAllAround(new WandPoofPacket(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, Color.WHITE.getRGB(), true, null), (ResourceKey<Level>)world.m_46472_(), BlockPos.m_274446_((Position)targetPos), 32.0);
                livingTarget.m_146870_();
                Entity newEntity = this.entityType.m_262451_(serverWorld, data, null, BlockPos.m_274446_((Position)targetPos), MobSpawnType.MOB_SUMMONED, false, false);
                newEntity.m_6593_(customName);
                newEntity.m_20340_(customNameVisible);
                world.m_7967_(newEntity);
                newEntity.m_19890_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, targetRots.f_82471_, targetRots.f_82470_);
                if (newEntity instanceof LivingEntity) {
                    LivingEntity newLivingEntity = (LivingEntity)newEntity;
                    newLivingEntity.m_21153_((float)(healthPercentage * (double)newLivingEntity.m_21233_()));
                    for (MobEffectInstance activeEffect : activeEffects) {
                        newLivingEntity.m_7292_(activeEffect);
                    }
                }
                if (this.polymorphDuration.isPresent()) {
                    int ticks = this.polymorphDuration.get();
                    if (newEntity instanceof LivingEntity) {
                        ((LivingEntity)newEntity).m_7292_(new MobEffectInstance((MobEffect)EffectsPM.POLYMORPH.get(), ticks));
                    }
                    return new EntitySwapper(newEntity.m_20148_(), oldType, this.originalData, Optional.empty(), ticks);
                }
                return null;
            }
        }
        return null;
    }

    protected boolean isValidTarget(Entity entity) {
        return entity instanceof LivingEntity && !(entity instanceof Player);
    }

    public void decrementDelay() {
        --this.delay;
    }

    public boolean isReady() {
        return this.delay <= 0;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.targetId != null) {
            nbt.m_128362_("TargetId", this.targetId);
        }
        if (this.entityType != null) {
            nbt.m_128359_("EntityType", EntityType.m_20613_(this.entityType).toString());
        }
        if (this.originalData != null) {
            nbt.m_128365_("OriginalData", (Tag)this.originalData);
        }
        if (this.polymorphDuration != null && this.polymorphDuration.isPresent()) {
            nbt.m_128405_("PolymorphDuration", this.polymorphDuration.get().intValue());
        }
        nbt.m_128405_("Delay", this.delay);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128403_("TargetId")) {
            this.targetId = nbt.m_128342_("TargetId");
        }
        if (nbt.m_128441_("EntityType")) {
            this.entityType = EntityType.m_20632_((String)nbt.m_128461_("EntityType")).orElse(null);
        }
        if (nbt.m_128441_("OriginalData")) {
            this.originalData = nbt.m_128469_("OriginalData");
        }
        this.polymorphDuration = nbt.m_128441_("PolymorphDuration") ? Optional.of(nbt.m_128451_("PolymorphDuration")) : Optional.empty();
        this.delay = nbt.m_128451_("Delay");
    }

    public boolean isValid() {
        return this.targetId != null && this.entityType != null;
    }

    @Nonnull
    protected CompoundTag pruneData(CompoundTag data, boolean initialSwap) {
        CompoundTag prunedData = new CompoundTag();
        prunedData.m_128391_(data);
        prunedData.m_128473_("id");
        prunedData.m_128473_("UUIDMost");
        prunedData.m_128473_("UUIDLeast");
        if (initialSwap) {
            prunedData.m_128473_("Health");
            prunedData.m_128473_("Attributes");
            prunedData.m_128473_("ActiveEffects");
        } else {
            prunedData.m_128473_("Pos");
            prunedData.m_128473_("Motion");
            prunedData.m_128473_("Rotation");
            prunedData.m_128473_("FallDistance");
            prunedData.m_128473_("Fire");
            prunedData.m_128473_("Air");
            prunedData.m_128473_("OnGround");
            prunedData.m_128473_("Glowing");
            prunedData.m_128473_("Health");
            prunedData.m_128473_("AbsorptionAmount");
            prunedData.m_128473_("DeathTime");
            prunedData.m_128473_("Attributes");
            prunedData.m_128473_("ActiveEffects");
        }
        return prunedData;
    }
}

