/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToServer;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.ResearchTopicFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SetResearchTopicHistoryPacket
implements IMessageToServer {
    protected CompoundTag data;

    public SetResearchTopicHistoryPacket() {
        this.data = null;
    }

    public SetResearchTopicHistoryPacket(AbstractResearchTopic current, List<AbstractResearchTopic> history) {
        this.data = new CompoundTag();
        this.data.m_128365_("Current", (Tag)current.serializeNBT());
        ListTag list = new ListTag();
        for (AbstractResearchTopic topic : history) {
            list.add((Object)topic.serializeNBT());
        }
        this.data.m_128365_("History", (Tag)list);
    }

    public static void encode(SetResearchTopicHistoryPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SetResearchTopicHistoryPacket decode(FriendlyByteBuf buf) {
        SetResearchTopicHistoryPacket message = new SetResearchTopicHistoryPacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SetResearchTopicHistoryPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
                    knowledge.setLastResearchTopic(ResearchTopicFactory.deserializeNBT(message.data.m_128469_("Current")));
                    LinkedList<AbstractResearchTopic> historyList = new LinkedList<AbstractResearchTopic>();
                    ListTag historyTag = message.data.m_128437_("History", 10);
                    for (int index = 0; index < historyTag.size(); ++index) {
                        AbstractResearchTopic topic = ResearchTopicFactory.deserializeNBT(historyTag.m_128728_(index));
                        if (topic == null) continue;
                        historyList.add(topic);
                    }
                    knowledge.setResearchTopicHistory(historyList);
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

