/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerAttunements;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncAttunementsPacket
implements IMessageToClient {
    protected CompoundTag data;

    public SyncAttunementsPacket() {
        this.data = null;
    }

    public SyncAttunementsPacket(Player player) {
        IPlayerAttunements attunements = PrimalMagickCapabilities.getAttunements(player);
        this.data = attunements != null ? (CompoundTag)attunements.serializeNBT() : null;
    }

    public static void encode(SyncAttunementsPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SyncAttunementsPacket decode(FriendlyByteBuf buf) {
        SyncAttunementsPacket message = new SyncAttunementsPacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncAttunementsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Object player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
                IPlayerAttunements attunements = PrimalMagickCapabilities.getAttunements(player);
                if (attunements != null) {
                    attunements.deserializeNBT((Tag)message.data);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

