/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncCompanionsPacket
implements IMessageToClient {
    protected CompoundTag data;

    public SyncCompanionsPacket() {
        this.data = null;
    }

    public SyncCompanionsPacket(Player player) {
        IPlayerCompanions companions = PrimalMagickCapabilities.getCompanions(player);
        this.data = companions != null ? (CompoundTag)companions.serializeNBT() : null;
    }

    public static void encode(SyncCompanionsPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SyncCompanionsPacket decode(FriendlyByteBuf buf) {
        SyncCompanionsPacket message = new SyncCompanionsPacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncCompanionsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Object player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
                IPlayerCompanions companions = PrimalMagickCapabilities.getCompanions(player);
                if (companions != null) {
                    companions.deserializeNBT((Tag)message.data);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

