/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncCooldownsPacket
implements IMessageToClient {
    protected CompoundTag data;

    public SyncCooldownsPacket() {
        this.data = null;
    }

    public SyncCooldownsPacket(Player player) {
        IPlayerCooldowns cooldowns = PrimalMagickCapabilities.getCooldowns(player);
        this.data = cooldowns != null ? (CompoundTag)cooldowns.serializeNBT() : null;
    }

    public static void encode(SyncCooldownsPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SyncCooldownsPacket decode(FriendlyByteBuf buf) {
        SyncCooldownsPacket message = new SyncCooldownsPacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncCooldownsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Object player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
                IPlayerCooldowns cooldowns = PrimalMagickCapabilities.getCooldowns(player);
                if (cooldowns != null) {
                    cooldowns.deserializeNBT((Tag)message.data);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

