/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.toast.ToastManager;
import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncKnowledgePacket
implements IMessageToClient {
    protected CompoundTag data;

    public SyncKnowledgePacket() {
        this.data = null;
    }

    public SyncKnowledgePacket(Player player) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        this.data = knowledge != null ? (CompoundTag)knowledge.serializeNBT() : null;
    }

    public static void encode(SyncKnowledgePacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SyncKnowledgePacket decode(FriendlyByteBuf buf) {
        SyncKnowledgePacket message = new SyncKnowledgePacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncKnowledgePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Player player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
                PrimalMagickCapabilities.getKnowledge(player).ifPresent(knowledge -> {
                    knowledge.deserializeNBT((Tag)message.data);
                    for (SimpleResearchKey key : knowledge.getResearchSet()) {
                        if (!knowledge.hasResearchFlag(key, IPlayerKnowledge.ResearchFlag.POPUP)) continue;
                        ResearchEntry entry = ResearchEntries.getEntry(key);
                        if (entry != null && FMLEnvironment.dist == Dist.CLIENT) {
                            ToastManager.showResearchToast(entry, knowledge.isResearchComplete(entry.getKey()));
                        }
                        knowledge.removeResearchFlag(key, IPlayerKnowledge.ResearchFlag.POPUP);
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

