/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.network.packets.data;

import com.verdantartifice.primalmagick.client.util.ClientUtils;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.packets.IMessageToClient;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncLinguisticsPacket
implements IMessageToClient {
    protected CompoundTag data;

    public SyncLinguisticsPacket() {
        this.data = null;
    }

    public SyncLinguisticsPacket(Player player) {
        IPlayerLinguistics linguistics = (IPlayerLinguistics)PrimalMagickCapabilities.getLinguistics(player).orElse(null);
        this.data = linguistics != null ? (CompoundTag)linguistics.serializeNBT() : null;
    }

    public static void encode(SyncLinguisticsPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.data);
    }

    public static SyncLinguisticsPacket decode(FriendlyByteBuf buf) {
        SyncLinguisticsPacket message = new SyncLinguisticsPacket();
        message.data = buf.m_130260_();
        return message;
    }

    public static class Handler {
        public static void onMessage(SyncLinguisticsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Player player = FMLEnvironment.dist == Dist.CLIENT ? ClientUtils.getCurrentPlayer() : null;
                PrimalMagickCapabilities.getLinguistics(player).ifPresent(linguistics -> linguistics.deserializeNBT((Tag)message.data));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

